/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.bcel.external.generic;

import jdk7u.jaxp.org.apache.bcel.external.generic.ClassGenException;
import jdk7u.jaxp.org.apache.bcel.external.generic.ConstantPoolGen;
import jdk7u.jaxp.org.apache.bcel.external.generic.ConstantPushInstruction;
import jdk7u.jaxp.org.apache.bcel.external.generic.Instruction;
import jdk7u.jaxp.org.apache.bcel.external.generic.Type;
import jdk7u.jaxp.org.apache.bcel.external.generic.TypedInstruction;
import jdk7u.jaxp.org.apache.bcel.external.generic.Visitor;

public class FCONST
extends Instruction
implements ConstantPushInstruction,
TypedInstruction {
    private float value;

    FCONST() {
    }

    public FCONST(float f) {
        super((short)11, (short)1);
        if ((double)f == 0.0) {
            this.opcode = (short)11;
        } else if ((double)f == 1.0) {
            this.opcode = (short)12;
        } else if ((double)f == 2.0) {
            this.opcode = (short)13;
        } else {
            throw new ClassGenException("FCONST can be used only for 0.0, 1.0 and 2.0: " + f);
        }
        this.value = f;
    }

    @Override
    public Number getValue() {
        return new Float(this.value);
    }

    @Override
    public Type getType(ConstantPoolGen cp) {
        return Type.FLOAT;
    }

    @Override
    public void accept(Visitor v) {
        v.visitPushInstruction(this);
        v.visitStackProducer(this);
        v.visitTypedInstruction(this);
        v.visitConstantPushInstruction(this);
        v.visitFCONST(this);
    }
}

