/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.bcel.external.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import jdk7u.jaxp.org.apache.bcel.external.Constants;
import jdk7u.jaxp.org.apache.bcel.external.classfile.Constant;
import jdk7u.jaxp.org.apache.bcel.external.classfile.ConstantClass;
import jdk7u.jaxp.org.apache.bcel.external.classfile.ConstantPool;
import jdk7u.jaxp.org.apache.bcel.external.generic.ClassGenException;
import jdk7u.jaxp.org.apache.bcel.external.generic.ConstantPoolGen;
import jdk7u.jaxp.org.apache.bcel.external.generic.IndexedInstruction;
import jdk7u.jaxp.org.apache.bcel.external.generic.Instruction;
import jdk7u.jaxp.org.apache.bcel.external.generic.Type;
import jdk7u.jaxp.org.apache.bcel.external.generic.TypedInstruction;
import jdk7u.jaxp.org.apache.bcel.external.util.ByteSequence;

public abstract class CPInstruction
extends Instruction
implements TypedInstruction,
IndexedInstruction {
    protected int index;

    CPInstruction() {
    }

    protected CPInstruction(short opcode, int index) {
        super(opcode, (short)3);
        this.setIndex(index);
    }

    @Override
    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(this.opcode);
        out.writeShort(this.index);
    }

    @Override
    public String toString(boolean verbose) {
        return super.toString(verbose) + " " + this.index;
    }

    @Override
    public String toString(ConstantPool cp) {
        Constant c = cp.getConstant(this.index);
        String str = cp.constantToString(c);
        if (c instanceof ConstantClass) {
            str = str.replace('.', '/');
        }
        return Constants.OPCODE_NAMES[this.opcode] + " " + str;
    }

    @Override
    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        this.setIndex(bytes.readUnsignedShort());
        this.length = (short)3;
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        if (index < 0) {
            throw new ClassGenException("Negative index value: " + index);
        }
        this.index = index;
    }

    @Override
    public Type getType(ConstantPoolGen cpg) {
        ConstantPool cp = cpg.getConstantPool();
        String name = cp.getConstantString(this.index, (byte)7);
        if (!name.startsWith("[")) {
            name = "L" + name + ";";
        }
        return Type.getType(name);
    }
}

