/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.bcel.external.generic;

import jdk7u.jaxp.org.apache.bcel.external.generic.BranchInstruction;
import jdk7u.jaxp.org.apache.bcel.external.generic.ClassGenException;
import jdk7u.jaxp.org.apache.bcel.external.generic.Instruction;
import jdk7u.jaxp.org.apache.bcel.external.generic.InstructionHandle;

public final class BranchHandle
extends InstructionHandle {
    private BranchInstruction bi;
    private static BranchHandle bh_list = null;

    private BranchHandle(BranchInstruction i) {
        super(i);
        this.bi = i;
    }

    static final BranchHandle getBranchHandle(BranchInstruction i) {
        if (bh_list == null) {
            return new BranchHandle(i);
        }
        BranchHandle bh = bh_list;
        bh_list = (BranchHandle)bh.next;
        bh.setInstruction(i);
        return bh;
    }

    @Override
    protected void addHandle() {
        this.next = bh_list;
        bh_list = this;
    }

    @Override
    public int getPosition() {
        return this.bi.position;
    }

    @Override
    void setPosition(int pos) {
        this.i_position = this.bi.position = pos;
    }

    @Override
    protected int updatePosition(int offset, int max_offset) {
        int x = this.bi.updatePosition(offset, max_offset);
        this.i_position = this.bi.position;
        return x;
    }

    public void setTarget(InstructionHandle ih) {
        this.bi.setTarget(ih);
    }

    public void updateTarget(InstructionHandle old_ih, InstructionHandle new_ih) {
        this.bi.updateTarget(old_ih, new_ih);
    }

    public InstructionHandle getTarget() {
        return this.bi.getTarget();
    }

    @Override
    public void setInstruction(Instruction i) {
        super.setInstruction(i);
        if (!(i instanceof BranchInstruction)) {
            throw new ClassGenException("Assigning " + i + " to branch handle which is not a branch instruction");
        }
        this.bi = (BranchInstruction)i;
    }
}

