/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.bcel.external.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jdk7u.jaxp.org.apache.bcel.external.classfile.Attribute;
import jdk7u.jaxp.org.apache.bcel.external.classfile.Constant;
import jdk7u.jaxp.org.apache.bcel.external.classfile.ConstantDouble;
import jdk7u.jaxp.org.apache.bcel.external.classfile.ConstantFloat;
import jdk7u.jaxp.org.apache.bcel.external.classfile.ConstantInteger;
import jdk7u.jaxp.org.apache.bcel.external.classfile.ConstantLong;
import jdk7u.jaxp.org.apache.bcel.external.classfile.ConstantPool;
import jdk7u.jaxp.org.apache.bcel.external.classfile.ConstantString;
import jdk7u.jaxp.org.apache.bcel.external.classfile.ConstantUtf8;
import jdk7u.jaxp.org.apache.bcel.external.classfile.Utility;
import jdk7u.jaxp.org.apache.bcel.external.classfile.Visitor;

public final class ConstantValue
extends Attribute {
    private int constantvalue_index;

    public ConstantValue(ConstantValue c) {
        this(c.getNameIndex(), c.getLength(), c.getConstantValueIndex(), c.getConstantPool());
    }

    ConstantValue(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, file.readUnsignedShort(), constant_pool);
    }

    public ConstantValue(int name_index, int length, int constantvalue_index, ConstantPool constant_pool) {
        super((byte)1, name_index, length, constant_pool);
        this.constantvalue_index = constantvalue_index;
    }

    @Override
    public void accept(Visitor v) {
        v.visitConstantValue(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.constantvalue_index);
    }

    public final int getConstantValueIndex() {
        return this.constantvalue_index;
    }

    public final void setConstantValueIndex(int constantvalue_index) {
        this.constantvalue_index = constantvalue_index;
    }

    @Override
    public final String toString() {
        String buf;
        Constant c = this.constant_pool.getConstant(this.constantvalue_index);
        switch (c.getTag()) {
            case 5: {
                buf = "" + ((ConstantLong)c).getBytes();
                break;
            }
            case 4: {
                buf = "" + ((ConstantFloat)c).getBytes();
                break;
            }
            case 6: {
                buf = "" + ((ConstantDouble)c).getBytes();
                break;
            }
            case 3: {
                buf = "" + ((ConstantInteger)c).getBytes();
                break;
            }
            case 8: {
                int i = ((ConstantString)c).getStringIndex();
                c = this.constant_pool.getConstant(i, (byte)1);
                buf = "\"" + Utility.convertString(((ConstantUtf8)c).getBytes()) + "\"";
                break;
            }
            default: {
                throw new IllegalStateException("Type of ConstValue invalid: " + c);
            }
        }
        return buf;
    }

    @Override
    public Attribute copy(ConstantPool constant_pool) {
        ConstantValue c = (ConstantValue)this.clone();
        c.constant_pool = constant_pool;
        return c;
    }
}

