/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.bcel.external.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jdk7u.jaxp.org.apache.bcel.external.classfile.Constant;
import jdk7u.jaxp.org.apache.bcel.external.classfile.ConstantObject;
import jdk7u.jaxp.org.apache.bcel.external.classfile.ConstantPool;
import jdk7u.jaxp.org.apache.bcel.external.classfile.Visitor;

public final class ConstantFloat
extends Constant
implements ConstantObject {
    private float bytes;

    public ConstantFloat(float bytes) {
        super((byte)4);
        this.bytes = bytes;
    }

    public ConstantFloat(ConstantFloat c) {
        this(c.getBytes());
    }

    ConstantFloat(DataInputStream file) throws IOException {
        this(file.readFloat());
    }

    @Override
    public void accept(Visitor v) {
        v.visitConstantFloat(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(this.tag);
        file.writeFloat(this.bytes);
    }

    public final float getBytes() {
        return this.bytes;
    }

    public final void setBytes(float bytes) {
        this.bytes = bytes;
    }

    @Override
    public final String toString() {
        return super.toString() + "(bytes = " + this.bytes + ")";
    }

    @Override
    public Object getConstantValue(ConstantPool cp) {
        return new Float(this.bytes);
    }
}

