/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.bcel.external.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jdk7u.jaxp.org.apache.bcel.external.classfile.Constant;
import jdk7u.jaxp.org.apache.bcel.external.classfile.ConstantObject;
import jdk7u.jaxp.org.apache.bcel.external.classfile.ConstantPool;
import jdk7u.jaxp.org.apache.bcel.external.classfile.Visitor;

public final class ConstantDouble
extends Constant
implements ConstantObject {
    private double bytes;

    public ConstantDouble(double bytes) {
        super((byte)6);
        this.bytes = bytes;
    }

    public ConstantDouble(ConstantDouble c) {
        this(c.getBytes());
    }

    ConstantDouble(DataInputStream file) throws IOException {
        this(file.readDouble());
    }

    @Override
    public void accept(Visitor v) {
        v.visitConstantDouble(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(this.tag);
        file.writeDouble(this.bytes);
    }

    public final double getBytes() {
        return this.bytes;
    }

    public final void setBytes(double bytes) {
        this.bytes = bytes;
    }

    @Override
    public final String toString() {
        return super.toString() + "(bytes = " + this.bytes + ")";
    }

    @Override
    public Object getConstantValue(ConstantPool cp) {
        return new Double(this.bytes);
    }
}

