/*
 * reserved comment block
 * DO NOT REMOVE OR ALTER!
 */
/*
 * Copyright 2001-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * $Id: ParentPattern.java,v 1.2.4.1 2005/09/02 11:10:09 pvedula Exp $
 */

package jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler;

import jdk7u.jaxp.org.apache.bcel.external.generic.ConstantPoolGen;
import jdk7u.jaxp.org.apache.bcel.external.generic.ILOAD;
import jdk7u.jaxp.org.apache.bcel.external.generic.INVOKEINTERFACE;
import jdk7u.jaxp.org.apache.bcel.external.generic.ISTORE;
import jdk7u.jaxp.org.apache.bcel.external.generic.InstructionHandle;
import jdk7u.jaxp.org.apache.bcel.external.generic.InstructionList;
import jdk7u.jaxp.org.apache.bcel.external.generic.LocalVariableGen;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.ClassGenerator;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.MethodGenerator;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.Type;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.TypeCheckError;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.Util;

/**
 * @author Jacek Ambroziak
 * @author Santiago Pericas-Geertsen
 */
final class ParentPattern extends RelativePathPattern {
    private final Pattern _left;
    private final RelativePathPattern _right;

    public ParentPattern(Pattern left, RelativePathPattern right) {
        (_left = left).setParent(this);
        (_right = right).setParent(this);
    }

    public void setParser(Parser parser) {
        super.setParser(parser);
        _left.setParser(parser);
        _right.setParser(parser);
    }

    public boolean isWildcard() {
        return false;
    }

    public StepPattern getKernelPattern() {
        return _right.getKernelPattern();
    }

    public void reduceKernelPattern() {
        _right.reduceKernelPattern();
    }

    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        _left.typeCheck(stable);
        return _right.typeCheck(stable);
    }

    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        final ConstantPoolGen cpg = classGen.getConstantPool();
        final InstructionList il = methodGen.getInstructionList();
        final LocalVariableGen local =
            methodGen.addLocalVariable2("ppt",
                                        Util.getJCRefType(NODE_SIG),
                                        null);

        final jdk7u.jaxp.org.apache.bcel.external.generic.Instruction loadLocal =
            new ILOAD(local.getIndex());
        final jdk7u.jaxp.org.apache.bcel.external.generic.Instruction storeLocal =
            new ISTORE(local.getIndex());

        if (_right.isWildcard()) {
            il.append(methodGen.loadDOM());
            il.append(SWAP);
        }
        else if (_right instanceof StepPattern) {
            il.append(DUP);
            local.setStart(il.append(storeLocal));

            _right.translate(classGen, methodGen);

            il.append(methodGen.loadDOM());
            local.setEnd(il.append(loadLocal));
        }
        else {
            _right.translate(classGen, methodGen);

            if (_right instanceof AncestorPattern) {
                il.append(methodGen.loadDOM());
                il.append(SWAP);
            }
        }

        final int getParent = cpg.addInterfaceMethodref(DOM_INTF,
                                                        GET_PARENT,
                                                        GET_PARENT_SIG);
        il.append(new INVOKEINTERFACE(getParent, 2));

        final SyntaxTreeNode p = getParent();
        if (p == null || p instanceof Instruction ||
            p instanceof TopLevelElement)
        {
            _left.translate(classGen, methodGen);
        }
        else {
            il.append(DUP);
            InstructionHandle storeInst = il.append(storeLocal);

            if (local.getStart() == null) {
                local.setStart(storeInst);
            }

            _left.translate(classGen, methodGen);

            il.append(methodGen.loadDOM());
            local.setEnd(il.append(loadLocal));
        }

        methodGen.removeLocalVariable(local);

        /*
         * If _right is an ancestor pattern, backpatch _left false
         * list to the loop that searches for more ancestors.
         */
        if (_right instanceof AncestorPattern) {
            final AncestorPattern ancestor = (AncestorPattern) _right;
            _left.backPatchFalseList(ancestor.getLoopHandle());    // clears list
        }

        _trueList.append(_right._trueList.append(_left._trueList));
        _falseList.append(_right._falseList.append(_left._falseList));
    }

    public String toString() {
        return "Parent(" + _left + ", " + _right + ')';
    }
}
