/*
 * Decompiled with CFR 0.152.
 */
package de.mhoffrogge.maven.plugins.p2site;

import de.mhoffrogge.maven.plugins.base.AbstractBaseMojo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

abstract class AbstractP2SiteMojo
extends AbstractBaseMojo {
    @Parameter(defaultValue="${basedir}", required=true)
    private String baseDir;
    @Parameter(required=false)
    private String relativeSnapshotsDir;
    @Parameter(required=false)
    private String relativeReleasesDir;
    @Parameter(defaultValue="updateSite.properties", required=true)
    private String updateSitePropertiesFileName;
    @Parameter(defaultValue="false", required=true)
    private boolean removeUpdateSitePropertiesFile;
    @Parameter(defaultValue="update.site.name", required=true)
    private String updateSiteNamePropertyName;
    @Parameter(defaultValue="update.site.dirname", required=true)
    private String updateSiteDirNamePropertyName;
    @Parameter(defaultValue="update.site.description", required=true)
    private String updateSiteDescriptionPropertyName;
    @Parameter(defaultValue="update.site.version", required=true)
    private String updateSiteVersionPropertyName;
    @Parameter(defaultValue="update.site.contents", required=true)
    private String updateSiteContentsPropertyName;
    @Parameter(defaultValue="update.site.forward", required=true)
    private String updateSiteForwardsBasePropertyName;
    @Parameter(defaultValue="false", required=true)
    private boolean isErrorIfNoUpdateSitePropertiesInBaseDir;
    @Parameter(defaultValue="false", required=true)
    private boolean compositeXmlsForFoldersWithUpdateSitePropertiesOnly;
    @Parameter(required=false)
    private String indexUpdateSiteTemplateFileName;
    @Parameter(required=false)
    private String indexNonUpdateSiteTemplateFileName;
    @Parameter(required=false)
    private String enforceBaseDirUpdateSitePropertiesFile;
    @Parameter(defaultValue="false", required=false)
    private boolean dryRun;
    @Parameter(defaultValue="${project.build.directory}/p2site_dryrun", required=true)
    private String dryRunFolder;
    private String indexUpdateSiteTemplate;
    private String indexNonUpdateSiteTemplate;
    private boolean isIndexHtmlCreated = false;
    private boolean isToCreateCompositeXmls = true;
    private boolean isToCreateIndexHtml = false;
    private Stack<Pair<String, List<String>>> folderStack = new Stack();
    private final List<File> filesToBeDeletedAfterRun = new ArrayList<File>();
    private static final String INDEX_HTML_FILE_NAME = "index.html";
    private static final String FOLDER_NAME_IS_VERSION_PATTERN = "^[0-9]+\\.[0-9]+.*";
    private static final String COMPOSITE_ARTIFACTS_BASENAME = "compositeArtifacts";
    private static final String COMPOSITE_CONTENT_BASENAME = "compositeContent";
    private static final String COMPOSITE_CONTENT_EXTENSION = ".xml";
    private static final String COMPOSITE_ARTIFACTS_FILENAME = "compositeArtifacts.xml";
    private static final String COMPOSITE_CONTENT_FILENAME = "compositeContent.xml";
    private static final String DEFAULT_UPDATE_SITE_DESCRIPTION = "Eclipse P2 Plugins";

    AbstractP2SiteMojo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeInternal(boolean isToCreateCompositeXmls, boolean isToCreateIndexHtml) throws MojoExecutionException, MojoFailureException {
        try {
            this.isToCreateCompositeXmls = isToCreateCompositeXmls;
            this.isToCreateIndexHtml = isToCreateIndexHtml;
            this.indexUpdateSiteTemplate = this.getIndexTemplate(this.indexUpdateSiteTemplateFileName, "updateSiteIndex_Template.html");
            this.indexNonUpdateSiteTemplate = this.getIndexTemplate(this.indexNonUpdateSiteTemplateFileName, "nonUpdateSiteIndex_Template.html");
            this.enforceBaseDirUpdateSitePropertiesFileIfConfigured();
            this.getLog().info((CharSequence)("Walking directories for " + this.updateSitePropertiesFileName + " files ..."));
            this.walkAllFiles(this.getEffectiveBaseDir(), 0);
            if (this.isToCreateIndexHtml && !this.isIndexHtmlCreated) {
                this.getLog().warn((CharSequence)"NO index.html files did have been created.");
            }
        }
        finally {
            for (File fileToBeDeleted : this.filesToBeDeletedAfterRun) {
                this.getLog().info((CharSequence)("CLEANUP " + fileToBeDeleted.getAbsolutePath()));
                FileUtils.deleteQuietly((File)fileToBeDeleted);
            }
        }
    }

    protected File getEffectiveBaseDir() {
        boolean isProjectSnapshotVersion = this.isProjectSnapshotVersion();
        if (isProjectSnapshotVersion && StringUtils.isNotBlank((CharSequence)this.relativeSnapshotsDir)) {
            return new File(this.baseDir, this.relativeSnapshotsDir);
        }
        if (!isProjectSnapshotVersion && StringUtils.isNotBlank((CharSequence)this.relativeReleasesDir)) {
            return new File(this.baseDir, this.relativeReleasesDir);
        }
        return new File(this.baseDir);
    }

    protected void enforceBaseDirUpdateSitePropertiesFileIfConfigured() throws MojoFailureException {
        if (StringUtils.isBlank((CharSequence)this.enforceBaseDirUpdateSitePropertiesFile)) {
            return;
        }
        File sourceFile = new File(this.enforceBaseDirUpdateSitePropertiesFile);
        if (!sourceFile.exists()) {
            throw new MojoFailureException("File does not exist: " + sourceFile.getAbsolutePath());
        }
        if (!sourceFile.isFile()) {
            throw new MojoFailureException("This path is not of type file: " + sourceFile.getAbsolutePath());
        }
        File targetFile = new File(this.getEffectiveBaseDir(), this.updateSitePropertiesFileName);
        if (this.dryRun) {
            if (targetFile.exists()) {
                this.getLog().warn((CharSequence)("Existing file " + targetFile.getAbsolutePath() + " did not have been overridden since of DRY RUN!"));
                return;
            }
            this.filesToBeDeletedAfterRun.add(targetFile);
        }
        try {
            FileUtils.copyFile((File)sourceFile, (File)targetFile);
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to copy file: " + sourceFile.getAbsolutePath() + " to " + targetFile.getAbsolutePath(), (Throwable)e);
        }
        this.getLog().info((CharSequence)("Enforced initial updateSite properties: " + sourceFile.getAbsolutePath() + " -> " + targetFile.getAbsolutePath()));
    }

    protected String getIndexTemplate(String indexTemplateFileName, String defaultResourceName) throws MojoFailureException {
        InputStream indexTemplateStream = null;
        try {
            Object indexTemplateFile;
            if (StringUtils.isNotBlank((CharSequence)indexTemplateFileName)) {
                indexTemplateFile = new File(indexTemplateFileName);
                if (!((File)indexTemplateFile).exists()) {
                    throw new MojoFailureException("Index template file does not exist: " + ((File)indexTemplateFile).getAbsolutePath());
                }
                if (!((File)indexTemplateFile).isFile()) {
                    throw new MojoFailureException("Index template file is not a file: " + ((File)indexTemplateFile).getAbsolutePath());
                }
                try {
                    indexTemplateStream = new FileInputStream((File)indexTemplateFile);
                }
                catch (FileNotFoundException e) {
                    throw new MojoFailureException("Index template file does not exist or is not readable: " + ((File)indexTemplateFile).getAbsolutePath());
                }
            } else {
                indexTemplateStream = ((Object)((Object)this)).getClass().getResourceAsStream(defaultResourceName);
                if (indexTemplateStream == null) {
                    throw new MojoFailureException(defaultResourceName + " does not exist in this plugins JAR package.");
                }
            }
            try {
                indexTemplateFile = IOUtils.toString((InputStream)indexTemplateStream, (Charset)Charset.defaultCharset());
                return indexTemplateFile;
            }
            catch (IOException e) {
                throw new MojoFailureException("Failed to read the index template file.", (Throwable)e);
            }
        }
        finally {
            if (indexTemplateStream != null) {
                try {
                    indexTemplateStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void walkAllFiles(File dir, int depth) throws MojoFailureException {
        if (!dir.exists()) {
            throw new MojoFailureException("Directory does not exist: " + dir.getAbsolutePath());
        }
        if (!dir.isDirectory()) {
            throw new MojoFailureException("This file is not a directory: " + dir.getAbsolutePath());
        }
        File[] listOfFiles = dir.listFiles();
        if (listOfFiles == null) {
            return;
        }
        this.addFolderToFolderStackIfNeeded(depth, dir.getName());
        for (File file : listOfFiles) {
            if (!file.isFile() || !StringUtils.equalsIgnoreCase((CharSequence)this.updateSitePropertiesFileName, (CharSequence)file.getName())) continue;
            this.getLog().info((CharSequence)("Found " + file.getAbsolutePath()));
            Properties props = new Properties();
            try (FileInputStream finput = new FileInputStream(file);){
                props.load(finput);
            }
            catch (IOException e) {
                throw new MojoFailureException("Failed to read file: " + file.getAbsolutePath(), (Throwable)e);
            }
            this.createCompositeFilesAndIndexHtmlAsRequired(dir, props, depth, this.isToCreateCompositeXmls);
            if (this.removeUpdateSitePropertiesFile) {
                try {
                    Files.delete(Paths.get(file.toURI()));
                    this.getLog().info((CharSequence)("REMOVED " + file.getAbsolutePath()));
                }
                catch (IOException e) {
                    throw new MojoFailureException("Failed to remove file: " + file.getAbsolutePath(), (Throwable)e);
                }
            }
            return;
        }
        if (depth == 0 && this.isErrorIfNoUpdateSitePropertiesInBaseDir) {
            throw new MojoFailureException("File " + this.updateSitePropertiesFileName + " is missing in " + dir.getAbsolutePath());
        }
        for (File file : listOfFiles) {
            if (!file.isDirectory()) continue;
            this.walkAllFiles(file, depth + 1);
        }
        this.removeFolderFromFolderStackAndCreateCompositeXmlIfNeeded(depth, dir, "", null, this.isToCreateCompositeXmls);
    }

    protected void addFolderToFolderStackIfNeeded(int depth, String folderName) {
        if (depth >= this.folderStack.size()) {
            this.folderStack.push((Pair<String, List<String>>)Pair.of((Object)folderName, new ArrayList()));
        }
    }

    protected boolean removeFolderFromFolderStackAndCreateCompositeXmlIfNeeded(int depth, File dir, String repoName, Properties props, boolean isToCreateCompositeXmls) throws MojoFailureException {
        boolean ret = false;
        if (this.folderStack.size() > depth) {
            List listOfChilds = (List)this.folderStack.pop().getRight();
            this.addProbableForwardLinks(listOfChilds, props);
            if (isToCreateCompositeXmls && !listOfChilds.isEmpty()) {
                this.createCompositeXmls(listOfChilds, dir, repoName);
                ret = true;
            }
        }
        return ret;
    }

    protected void addProbableForwardLinks(List<String> listOfChilds, Properties props) {
        String forwardLink;
        if (props == null) {
            return;
        }
        int i = 1;
        while (!StringUtils.isBlank((CharSequence)(forwardLink = props.getProperty(this.updateSiteForwardsBasePropertyName + "." + i)))) {
            listOfChilds.add(forwardLink);
            ++i;
        }
    }

    protected void createCompositeXmls(List<String> listOfChilds, File dir, String repoName) throws MojoFailureException {
        this.getLog().info((CharSequence)(" Creating compositeXmls repoName=" + repoName + " with " + listOfChilds.size() + " childs for " + dir.getAbsolutePath()));
        long timeStamp = new Date().getTime();
        this.createCompositeXml(COMPOSITE_ARTIFACTS_BASENAME, timeStamp, listOfChilds, dir, repoName);
        this.createCompositeXml(COMPOSITE_CONTENT_BASENAME, timeStamp, listOfChilds, dir, repoName);
    }

    protected void createCompositeXml(String compositeBaseName, long timeStamp, List<String> listOfChilds, File dir, String repoName) throws MojoFailureException {
        String fileContent;
        String resourceName = compositeBaseName + "_Template" + COMPOSITE_CONTENT_EXTENSION;
        InputStream templateStream = ((Object)((Object)this)).getClass().getResourceAsStream(resourceName);
        if (templateStream == null) {
            throw new MojoFailureException(resourceName + " does not exist in this plugins JAR package.");
        }
        try {
            fileContent = IOUtils.toString((InputStream)templateStream, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to read the index template file.", (Throwable)e);
        }
        fileContent = AbstractP2SiteMojo.replaceFileContent(fileContent, repoName, "repoName");
        fileContent = AbstractP2SiteMojo.replaceFileContent(fileContent, Long.toString(timeStamp), "timeStamp");
        fileContent = AbstractP2SiteMojo.replaceFileContent(fileContent, Integer.toString(listOfChilds.size()), "childSize");
        StringBuilder sbFiles = new StringBuilder();
        for (String childLocation : listOfChilds) {
            if (sbFiles.length() > 0) {
                sbFiles.append("\n");
            }
            sbFiles.append(AbstractP2SiteMojo.buildCompositeLocation(childLocation));
        }
        fileContent = AbstractP2SiteMojo.replaceFileContent(fileContent, sbFiles.toString(), "childLocations");
        File compositeFile = new File(dir, compositeBaseName + COMPOSITE_CONTENT_EXTENSION);
        this.writeTargetFileConsideringDryRun(compositeFile, fileContent);
    }

    protected void writeTargetFileConsideringDryRun(File originalTargetFile, String fileContent) throws MojoFailureException {
        File effectiveTargetFile = this.dryRun ? new File(StringUtils.replaceOnce((String)originalTargetFile.getAbsolutePath(), (String)this.getEffectiveBaseDir().getAbsolutePath(), (String)new File(this.dryRunFolder).getAbsolutePath())) : originalTargetFile;
        try {
            FileUtils.write((File)effectiveTargetFile, (CharSequence)fileContent, (Charset)Charset.defaultCharset());
            this.getLog().info((CharSequence)("  " + (this.dryRun ? "DRYRUN - " : "") + "Created " + effectiveTargetFile.getAbsolutePath()));
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to write file: " + effectiveTargetFile.getAbsolutePath(), (Throwable)e);
        }
    }

    protected void addToCompositeChilds(int depth, String folderName) {
        String childFolderName = folderName;
        for (int i = depth - 1; i >= 0; --i) {
            ((List)((Pair)this.folderStack.elementAt(i)).getRight()).add(childFolderName);
            this.getLog().debug((CharSequence)(" Folder: " + (String)((Pair)this.folderStack.elementAt(i)).getLeft() + " -  added compoSiteChild[" + i + "]=" + childFolderName));
            childFolderName = (String)((Pair)this.folderStack.elementAt(i)).getLeft() + "/" + childFolderName;
        }
    }

    protected void createCompositeFilesAndIndexHtmlAsRequired(File dir, Properties props, int depth, boolean isToCreateCompositeXmls) throws MojoFailureException {
        this.addFolderToFolderStackIfNeeded(depth, dir.getName());
        props = new Properties(props);
        if (StringUtils.isBlank((CharSequence)props.getProperty(this.updateSiteVersionPropertyName)) && dir.getName().matches(FOLDER_NAME_IS_VERSION_PATTERN)) {
            props.setProperty(this.updateSiteVersionPropertyName, dir.getName());
        }
        Pair<Boolean, StringBuilder> pairUpdateSiteContent = this.getUpdateSiteContentFragment(dir, props, depth);
        boolean isUpdateSite = (Boolean)pairUpdateSiteContent.getLeft();
        StringBuilder sbFolderContent = (StringBuilder)pairUpdateSiteContent.getRight();
        if (isUpdateSite) {
            this.addToCompositeChilds(depth, dir.getName());
        }
        String repoName = props.getProperty(this.updateSiteNamePropertyName);
        String dirName = dir.getName();
        boolean isCompositeXmlCreated = this.removeFolderFromFolderStackAndCreateCompositeXmlIfNeeded(depth, dir, repoName, props, isToCreateCompositeXmls);
        if (isCompositeXmlCreated) {
            sbFolderContent.append("\n").append(AbstractP2SiteMojo.buildFileLink(COMPOSITE_ARTIFACTS_FILENAME));
            sbFolderContent.append("\n").append(AbstractP2SiteMojo.buildFileLink(COMPOSITE_CONTENT_FILENAME));
        }
        if (this.isToCreateIndexHtml) {
            String indexHtml = isUpdateSite ? new String(this.indexUpdateSiteTemplate) : new String(this.indexNonUpdateSiteTemplate);
            indexHtml = AbstractP2SiteMojo.replaceFileContent(indexHtml, repoName, this.updateSiteNamePropertyName);
            indexHtml = AbstractP2SiteMojo.replaceFileContent(indexHtml, dirName, this.updateSiteDirNamePropertyName);
            indexHtml = AbstractP2SiteMojo.replaceFileContent(indexHtml, (String)StringUtils.defaultIfBlank((CharSequence)props.getProperty(this.updateSiteDescriptionPropertyName), (CharSequence)DEFAULT_UPDATE_SITE_DESCRIPTION), this.updateSiteDescriptionPropertyName);
            indexHtml = AbstractP2SiteMojo.replaceFileContent(indexHtml, props.getProperty(this.updateSiteVersionPropertyName), this.updateSiteVersionPropertyName);
            indexHtml = AbstractP2SiteMojo.replaceFileContent(indexHtml, sbFolderContent.toString(), this.updateSiteContentsPropertyName);
            File indexHtmlFile = new File(dir, INDEX_HTML_FILE_NAME);
            this.writeTargetFileConsideringDryRun(indexHtmlFile, indexHtml);
            this.isIndexHtmlCreated = true;
        }
    }

    protected static String replaceFileContent(String fileContent, String value, String propertyName) {
        if (StringUtils.isBlank((CharSequence)value)) {
            value = "";
        }
        return StringUtils.replace((String)fileContent, (String)("${" + propertyName + "}"), (String)value);
    }

    protected Pair<Boolean, StringBuilder> getUpdateSiteContentFragment(File dir, Properties props, int depth) throws MojoFailureException {
        Object[] listOfFiles;
        boolean isUpdateSite = false;
        StringBuilder sbFolder = new StringBuilder();
        if (depth > 0) {
            sbFolder.append(AbstractP2SiteMojo.buildFolderLink(".."));
        }
        if ((listOfFiles = dir.listFiles()) == null || listOfFiles.length == 0) {
            return Pair.of((Object)isUpdateSite, (Object)sbFolder);
        }
        Arrays.sort(listOfFiles);
        StringBuilder sbFiles = new StringBuilder();
        for (Object file : listOfFiles) {
            if (((File)file).isFile() && !this.isExcludedFileName(((File)file).getName())) {
                if (sbFiles.length() > 0) {
                    sbFiles.append("\n");
                }
                sbFiles.append(AbstractP2SiteMojo.buildFileLink(((File)file).getName()));
                if (isUpdateSite) continue;
                isUpdateSite = this.isUpdateSiteFile(((File)file).getName());
                continue;
            }
            if (!((File)file).isDirectory() || this.isExcludedDirName(((File)file).getName())) continue;
            if (sbFolder.length() > 0) {
                sbFolder.append("\n");
            }
            sbFolder.append(AbstractP2SiteMojo.buildFolderLink(((File)file).getName()));
            File probablePropertiesFile = new File((File)file, this.updateSitePropertiesFileName);
            if (probablePropertiesFile.exists() && probablePropertiesFile.isFile()) {
                this.walkAllFiles((File)file, depth + 1);
                continue;
            }
            this.createCompositeFilesAndIndexHtmlAsRequired((File)file, props, depth + 1, this.isToCreateCompositeXmls && !this.compositeXmlsForFoldersWithUpdateSitePropertiesOnly);
        }
        sbFolder.append((CharSequence)sbFiles);
        return Pair.of((Object)isUpdateSite, (Object)sbFolder);
    }

    protected boolean isUpdateSiteFile(String fileName) {
        return StringUtils.equalsIgnoreCase((CharSequence)fileName, (CharSequence)"content.jar") || StringUtils.equalsIgnoreCase((CharSequence)fileName, (CharSequence)"artifacts.jar") || StringUtils.startsWithIgnoreCase((CharSequence)fileName, (CharSequence)"content.xml") || StringUtils.startsWithIgnoreCase((CharSequence)fileName, (CharSequence)"artifacts.xml") || StringUtils.equalsIgnoreCase((CharSequence)fileName, (CharSequence)"p2.index");
    }

    protected boolean isExcludedFileName(String fileName) {
        return StringUtils.equalsIgnoreCase((CharSequence)fileName, (CharSequence)this.updateSitePropertiesFileName) || StringUtils.equalsIgnoreCase((CharSequence)fileName, (CharSequence)INDEX_HTML_FILE_NAME) || StringUtils.startsWith((CharSequence)fileName, (CharSequence)".") || this.isToCreateCompositeXmls && (StringUtils.equalsIgnoreCase((CharSequence)fileName, (CharSequence)COMPOSITE_ARTIFACTS_FILENAME) || StringUtils.equalsIgnoreCase((CharSequence)fileName, (CharSequence)COMPOSITE_CONTENT_FILENAME));
    }

    protected boolean isExcludedDirName(String dirName) {
        return StringUtils.startsWith((CharSequence)dirName, (CharSequence)".");
    }

    protected static String buildFolderLink(String folderName) {
        return String.format("<img src='https://dev.eclipse.org/small_icons/places/folder.png'><a href='%s/'> %s</a><br />", folderName, folderName);
    }

    protected static String buildFileLink(String fileName) {
        return String.format("<img src='https://dev.eclipse.org/small_icons/actions/edit-copy.png'><a href='%s'> %s</a><br />", fileName, fileName);
    }

    protected static String buildCompositeLocation(String locationName) {
        return String.format("        <child location='%s'/>", locationName);
    }
}

