/*
 * Decompiled with CFR 0.152.
 */
package de.melnichuk.prettyconfiguration.renderer;

import de.melnichuk.prettyconfiguration.model.Model;
import de.melnichuk.prettyconfiguration.renderer.Renderer;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class FreemarkerRenderer
implements Renderer {
    private final File template;
    private final String outputDir;

    public FreemarkerRenderer(File template, String outputDir) {
        this.template = template;
        this.outputDir = outputDir;
    }

    private Configuration createConfiguration() throws IOException {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_26);
        cfg.setTemplateLoader((TemplateLoader)new FileTemplateLoader(this.template.getParentFile()));
        return cfg;
    }

    @Override
    public void render(Model model) throws Exception {
        this.render(model, this.getDefaultOutputFileName());
    }

    @Override
    public void render(Model model, String outputFileNameCandidate) throws Exception {
        String outputFileName = outputFileNameCandidate == null ? this.getDefaultOutputFileName() : outputFileNameCandidate;
        File output = new File(this.outputDir, outputFileName);
        this.createConfiguration().getTemplate(this.template.getName()).process((Object)model, (Writer)new FileWriter(output));
    }

    private String getDefaultOutputFileName() {
        return this.template.getName();
    }
}

