/*
 * Decompiled with CFR 0.152.
 */
package de.melnichuk.prettyconfiguration.model.configuration;

import de.melnichuk.prettyconfiguration.model.configuration.Configuration;
import de.melnichuk.prettyconfiguration.model.configuration.Property;
import de.melnichuk.prettyconfiguration.model.configuration.PropertyNameInformation;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesConfigurationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesConfigurationFactory.class);

    public List<Configuration> createConfigurationFromPropertiesFiles(Collection<File> files) {
        return files.stream().map(this::createConfigurationFromPropertiesFile).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<Configuration> createConfigurationFromPropertiesFilesInDirectory(String path) throws Exception {
        File[] files = new File(path).listFiles((dir, name) -> name.endsWith(".properties"));
        return this.createConfigurationFromPropertiesFiles(Arrays.asList(files));
    }

    public Configuration createConfigurationFromPropertiesFile(File file) {
        Properties properties = new Properties();
        try {
            properties.load(new FileReader(file));
        }
        catch (Exception e) {
            LOGGER.error("failed to load properties from " + file.getAbsolutePath(), (Throwable)e);
            return null;
        }
        return this.createConfigurationFromProperties(properties, file.getName());
    }

    public Configuration createConfigurationFromProperties(Properties properties, String identifier) {
        Configuration model = new Configuration(identifier);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String meta;
            PropertyNameInformation propertyNameInformation = PropertyNameInformation.extractFromPropertyName(key.toString());
            String name = propertyNameInformation.getName();
            Property property = model.getProperty(name);
            if (property == null) {
                property = new Property(name);
                model.addProperty(property);
            }
            if ((meta = propertyNameInformation.getMeta()) == null) {
                property.setValue(value.toString());
            } else {
                property.addMeta(meta, value.toString());
            }
        }));
        return model;
    }
}

