/*
 * Decompiled with CFR 0.152.
 */
package de.melnichuk.prettyconfiguration.model.configuration;

import de.melnichuk.prettyconfiguration.model.configuration.Property;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class Configuration {
    private final String identifier;
    private final Map<String, Property> properties = new TreeMap<String, Property>((a, b) -> a.compareTo((String)b));

    public Configuration(String identifier) {
        this.identifier = identifier;
    }

    public Collection<Property> getProperties() {
        return Collections.unmodifiableCollection(this.properties.values());
    }

    public Property getProperty(String name) {
        return this.properties.get(name);
    }

    public void addProperty(Property property) {
        this.properties.put(property.getName(), property);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void applyMixin(Configuration mixin) {
        mixin.getProperties().forEach(mixinProperty -> {
            Property property = this.properties.get(mixinProperty.getName());
            if (property == null) {
                this.addProperty((Property)mixinProperty);
            } else {
                Map<String, String> meta = property.getMeta();
                mixinProperty.getMeta().forEach((metaName, metaValue) -> {
                    if (!meta.containsKey(metaName)) {
                        property.addMeta((String)metaName, (String)metaValue);
                    }
                });
            }
        });
    }
}

