/*
 * Decompiled with CFR 0.152.
 */
package de.melnichuk.prettyconfiguration;

import com.beust.jcommander.JCommander;
import de.melnichuk.prettyconfiguration.Settings;
import de.melnichuk.prettyconfiguration.model.Model;
import de.melnichuk.prettyconfiguration.model.configuration.Configuration;
import de.melnichuk.prettyconfiguration.model.configuration.PropertiesConfigurationFactory;
import de.melnichuk.prettyconfiguration.renderer.FreemarkerRenderer;
import de.melnichuk.prettyconfiguration.renderer.Renderer;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);

    public static void main(String ... args) throws Exception {
        Settings settings = Main.setupSettings(args);
        Collection mixinFiles = settings.getInputMixinFiles().stream().map(path -> new File((String)path)).collect(Collectors.toSet());
        List<Configuration> mixins = new PropertiesConfigurationFactory().createConfigurationFromPropertiesFiles(mixinFiles);
        Collection files = settings.getInputFiles().stream().map(path -> new File((String)path)).collect(Collectors.toSet());
        List<Configuration> configurations = new PropertiesConfigurationFactory().createConfigurationFromPropertiesFiles(files);
        configurations.forEach(configuration -> mixins.forEach(mixin -> configuration.applyMixin((Configuration)mixin)));
        Model model = new Model(configurations);
        Renderer renderer = Main.setupRenderer(model, settings);
        renderer.render(model, settings.getOutputName());
    }

    private static Renderer setupRenderer(Model model, Settings settings) throws Exception {
        String outputDir = settings.getOutputDir();
        Main.ensureOutputDirExists(outputDir);
        File template = new File(settings.getTemplate());
        return new FreemarkerRenderer(template, outputDir);
    }

    private static void ensureOutputDirExists(String outputDir) {
        LOGGER.debug("checking {} exists.", (Object)outputDir);
        new File(outputDir).mkdirs();
    }

    private static Settings setupSettings(String ... args) {
        Settings settings = new Settings();
        JCommander.newBuilder().addObject((Object)settings).args(args).build();
        return settings;
    }
}

