/*
 * Decompiled with CFR 0.152.
 */
package de.melnichuk.events;

import de.melnichuk.events.Events;
import de.melnichuk.events.SamplingStrategy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DefaultEvents<T>
implements Events<T> {
    private final Map<Integer, LinkedList<T>> history = new HashMap<Integer, LinkedList<T>>();
    private SamplingStrategy<T> samplingStrategy = LinkedList::getFirst;
    private final int threshold;
    private LinkedList<T> itemBacklog = new LinkedList();
    private int itemBacklogCount = 10;
    private long count;

    public DefaultEvents(int threshold, int ... increments) {
        this.threshold = threshold;
        Arrays.stream(increments).forEach(i -> this.history.put(i, new LinkedList()));
    }

    @Override
    public void process(T item) {
        try {
            this.doProcess(item);
        }
        finally {
            ++this.count;
        }
    }

    private void doProcess(T item) {
        this.addItemToList(item, this.itemBacklog, this.itemBacklogCount);
        List matchingIncrementsAndSamples = this.history.entrySet().stream().filter(incrementAndSamples -> this.count % (long)((Integer)incrementAndSamples.getKey()).intValue() == 0L).collect(Collectors.toList());
        if (!matchingIncrementsAndSamples.isEmpty()) {
            T sample = this.samplingStrategy.getSample(this.itemBacklog);
            matchingIncrementsAndSamples.stream().map(incrementAndSamples -> (LinkedList)incrementAndSamples.getValue()).forEach(samples -> this.addItemToList(sample, (LinkedList<T>)samples, this.threshold));
        }
    }

    private void addItemToList(T event, LinkedList<T> samples, int threshold) {
        samples.addFirst(event);
        if (samples.size() > threshold) {
            samples.removeLast();
        }
    }

    @Override
    public Map<Integer, ? extends List<T>> getHistory() {
        return this.history;
    }
}

