/*
 * Decompiled with CFR 0.152.
 */
package de.melnichuk.events;

import de.melnichuk.events.Events;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynchronousEventsDelegate<T>
implements Events<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsynchronousEventsDelegate.class);
    private final ThreadPoolExecutor executorService;
    private final Events<T> events;
    private final int backlogSize;

    public AsynchronousEventsDelegate(Events<T> events, int backlogSize) {
        this.backlogSize = backlogSize;
        this.events = events;
        this.executorService = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    @Override
    public void process(T item) {
        if (this.executorService.getQueue().size() < this.backlogSize) {
            this.executorService.submit(() -> this.events.process(item));
        } else {
            LOGGER.warn("dropping item, because there are already to many items in backlog.");
        }
    }

    @Override
    public Map<Integer, ? extends List<T>> getHistory() {
        return this.events.getHistory();
    }
}

