/*
 * Decompiled with CFR 0.152.
 */
package de.mehtrick.bjoern.parser;

import de.mehtrick.bjoern.parser.replacer.UmloudReplacer;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;

public class BjoernTextParser {
    public static final String BLANK_REPLACEMENT = "";

    private static String parseTextToCamelCase(String text) {
        return WordUtils.capitalizeFully((String)text).trim().replaceAll(" ", BLANK_REPLACEMENT);
    }

    private static String removeInvalidChars(String formattedName) {
        List<String> removeChars = Arrays.asList("(", ")", ".", ",", "-", "_", ":", "=", "+", "'", "<", ">", "^");
        for (String removeChar : removeChars) {
            formattedName = StringUtils.remove((String)formattedName, (String)removeChar);
        }
        return formattedName;
    }

    public static String parseText(String name) {
        String formattedText = BjoernTextParser.removeInvalidChars(name);
        formattedText = BjoernTextParser.parseTextToCamelCase(formattedText);
        formattedText = StringUtils.deleteWhitespace((String)formattedText);
        formattedText = UmloudReplacer.replaceUmlaute(formattedText);
        return formattedText;
    }
}

