/*
 * Decompiled with CFR 0.152.
 */
package de.mehtrick.bjoern.parser.validator.validations;

import de.mehtrick.bjoern.parser.validator.BjoernValidationsException;
import de.mehtrick.bjoern.parser.validator.validations.AbstractValidation;
import de.mehtrick.bjoern.parser.validator.validations.BjoernKeywords;

public class InvalidKeywordValidation
extends AbstractValidation {
    public InvalidKeywordValidation(String errorText) {
        super(errorText);
    }

    @Override
    public void validate(String[] lines, int index) throws BjoernValidationsException {
        String trimmedLine = this.getTrimmedLine(lines, index);
        boolean lineDoesNotStartWithKnownKeyword = BjoernKeywords.getKeywordValues().stream().noneMatch(trimmedLine::startsWith);
        if (lineDoesNotStartWithKnownKeyword) {
            throw new BjoernValidationsException(index, this.errorText, lines[index], BjoernKeywords.getKeywordsAsSingleString());
        }
    }
}

