/*
 * Decompiled with CFR 0.152.
 */
package de.mehtrick.bjoern.parser.validator.validations;

import de.mehtrick.bjoern.parser.validator.BjoernValidationError;
import de.mehtrick.bjoern.parser.validator.BjoernValidationsException;
import de.mehtrick.bjoern.parser.validator.validations.BackgroundIndentationValidation;
import de.mehtrick.bjoern.parser.validator.validations.BjoernKeywords;
import de.mehtrick.bjoern.parser.validator.validations.FeatureKeywordValidation;
import de.mehtrick.bjoern.parser.validator.validations.InvalidKeywordValidation;
import de.mehtrick.bjoern.parser.validator.validations.MissingNameValidation;
import de.mehtrick.bjoern.parser.validator.validations.MissingStatementContent;
import de.mehtrick.bjoern.parser.validator.validations.ScenariosIndentationValidation;
import java.util.List;

public enum BjoernValidations {
    INVALID_KEYWORD("The line starts with an invalid Keyword. Found \"%s\". Allowed Keywords are: %s. This check is case-sensitive!"){

        @Override
        protected void validate(String[] lines, int index) throws BjoernValidationsException {
            new InvalidKeywordValidation(this.errorText).validate(lines, index);
        }
    }
    ,
    WRONSTARTINGKEYWORD("A bjoern file must start with the Keyword \"" + BjoernKeywords.FEATURE.keyword + "\", but starts with \"%s\". Please remove any indentation. This check is case-sensitive!"){

        @Override
        protected void validate(String[] lines, int index) throws BjoernValidationsException {
            new FeatureKeywordValidation(this.errorText).validate(lines, index);
        }
    }
    ,
    WRONG_INDENTATION_BACKGROUND("The keyword %s must have an indentation of %s but found %s"){

        @Override
        protected void validate(String[] lines, int index) throws BjoernValidationsException {
            new BackgroundIndentationValidation(this.errorText).validate(lines, index);
        }
    }
    ,
    WRONG_INDENTATION_SCENARIOS("The keyword %s must have an indentation of %s but found %s"){

        @Override
        protected void validate(String[] lines, int index) throws BjoernValidationsException {
            new ScenariosIndentationValidation(this.errorText).validate(lines, index);
        }
    }
    ,
    MISSINGNAMES("The keyword needs a value e.g. \"Feature: This is a Feature\" or \"Scenario: This is a Scneario\""){

        @Override
        protected void validate(String[] lines, int index) throws BjoernValidationsException {
            new MissingNameValidation(this.errorText).validate(lines, index);
        }
    }
    ,
    MISSING_STATEMENT_CONTENT("A statement shall not be empty"){

        @Override
        protected void validate(String[] lines, int index) throws BjoernValidationsException {
            new MissingStatementContent(this.errorText).validate(lines, index);
        }
    };

    final String errorText;

    private BjoernValidations(String errorText) {
        this.errorText = errorText;
    }

    public List<BjoernValidationError> validateLine(String[] lines, int index, List<BjoernValidationError> errors) {
        try {
            if (this.lineIsNotEmpty(lines, index)) {
                this.validate(lines, index);
            }
        }
        catch (BjoernValidationsException e) {
            errors.add(e.getBjoernValidationError());
        }
        return errors;
    }

    private boolean lineIsNotEmpty(String[] line, int index) {
        return line[index].trim().length() > 0;
    }

    protected abstract void validate(String[] var1, int var2) throws BjoernValidationsException;
}

