/*
 * Decompiled with CFR 0.152.
 */
package de.mehtrick.bjoern.parser.reader;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.mehtrick.UmloudReplacer;
import de.mehtrick.bjoern.parser.modell.BjoernZGRModell;
import de.mehtrick.bjoern.parser.reader.BjoernFileExtensionInvalidException;
import de.mehtrick.bjoern.parser.reader.BjoernFileExtensions;
import de.mehtrick.bjoern.parser.reader.BjoernZGRReaderException;
import de.mehtrick.bjoern.parser.validator.BjoernValidator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class BjoernZGRReader {
    public static BjoernZGRModell readSpec(String path) {
        try {
            File zgr = BjoernZGRReader.getFileFromPath(path);
            String zgrAsString = FileUtils.readFileToString((File)zgr, (Charset)Charset.defaultCharset());
            zgrAsString = UmloudReplacer.replaceUmlaute(zgrAsString);
            new BjoernValidator().validate(zgrAsString, path);
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            return (BjoernZGRModell)mapper.readValue(zgrAsString, BjoernZGRModell.class);
        }
        catch (IOException e) {
            throw new BjoernZGRReaderException(path, e);
        }
    }

    private static File getFileFromPath(String path) throws FileNotFoundException {
        BjoernZGRReader.checkFileExtension(path);
        File yaml = new File(path);
        BjoernZGRReader.checkFileExists(path, yaml);
        return yaml;
    }

    private static void checkFileExists(String path, File yaml) throws FileNotFoundException {
        if (!yaml.exists()) {
            throw new FileNotFoundException("No file found under the path " + path);
        }
    }

    private static void checkFileExtension(String path) {
        if (!StringUtils.endsWithAny((CharSequence)path, (CharSequence[])BjoernFileExtensions.getValuesAsString())) {
            throw new BjoernFileExtensionInvalidException();
        }
    }
}

