/*
 * Decompiled with CFR 0.152.
 */
package de.mehtrick.bjoern.parser.modell;

import de.mehtrick.bjoern.parser.BjoernTextParser;
import de.mehtrick.bjoern.parser.modell.BjoernBackground;
import de.mehtrick.bjoern.parser.modell.BjoernScenario;
import de.mehtrick.bjoern.parser.modell.BjoernZGRModell;
import java.util.List;
import java.util.stream.Collectors;

public class Bjoern {
    private String feature;
    private BjoernBackground background;
    private List<BjoernScenario> scenarios;
    private String filePath;

    public Bjoern(BjoernZGRModell yamlModell, String path) {
        this.setFeature(yamlModell.getFeature());
        this.setScenarios(yamlModell.getScenarios().stream().map(BjoernScenario::new).collect(Collectors.toList()));
        this.setFilePath(path);
        if (yamlModell.getBackground() != null) {
            this.setBackground(new BjoernBackground(yamlModell.getBackground()));
        }
    }

    public String getFeatureNameFormatted() {
        return BjoernTextParser.parseText(this.getFeature());
    }

    public String getFeature() {
        return this.feature;
    }

    public BjoernBackground getBackground() {
        return this.background;
    }

    public List<BjoernScenario> getScenarios() {
        return this.scenarios;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFeature(String feature) {
        this.feature = feature;
    }

    public void setBackground(BjoernBackground background) {
        this.background = background;
    }

    public void setScenarios(List<BjoernScenario> scenarios) {
        this.scenarios = scenarios;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bjoern)) {
            return false;
        }
        Bjoern other = (Bjoern)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$feature = this.getFeature();
        String other$feature = other.getFeature();
        if (this$feature == null ? other$feature != null : !this$feature.equals(other$feature)) {
            return false;
        }
        BjoernBackground this$background = this.getBackground();
        BjoernBackground other$background = other.getBackground();
        if (this$background == null ? other$background != null : !((Object)this$background).equals(other$background)) {
            return false;
        }
        List<BjoernScenario> this$scenarios = this.getScenarios();
        List<BjoernScenario> other$scenarios = other.getScenarios();
        if (this$scenarios == null ? other$scenarios != null : !((Object)this$scenarios).equals(other$scenarios)) {
            return false;
        }
        String this$filePath = this.getFilePath();
        String other$filePath = other.getFilePath();
        return !(this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Bjoern;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $feature = this.getFeature();
        result = result * 59 + ($feature == null ? 43 : $feature.hashCode());
        BjoernBackground $background = this.getBackground();
        result = result * 59 + ($background == null ? 43 : ((Object)$background).hashCode());
        List<BjoernScenario> $scenarios = this.getScenarios();
        result = result * 59 + ($scenarios == null ? 43 : ((Object)$scenarios).hashCode());
        String $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
        return result;
    }

    public String toString() {
        return "Bjoern(feature=" + this.getFeature() + ", background=" + this.getBackground() + ", scenarios=" + this.getScenarios() + ", filePath=" + this.getFilePath() + ")";
    }
}

