/*
 * Decompiled with CFR 0.152.
 */
package de.mehtrick.bjoern.parser.modell;

import de.mehtrick.bjoern.parser.BjoernTextParser;
import de.mehtrick.bjoern.parser.modell.BDDKeyword;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class BjoernStatement {
    private static final String PARAMETERPATTERN = "\"(.*?)\"";
    private String primitiveStatement;
    private String statementWithoutParameters;
    private List<String> parameters = new ArrayList<String>();

    public BjoernStatement(String statement, BDDKeyword keyword) {
        this.setPrimitiveStatement(statement);
        this.setStatementWithoutParameters(keyword.name().toLowerCase() + "_" + this.removeParametersFromStatement(statement));
        this.parseParameters(statement);
    }

    private void parseParameters(String statement) {
        Pattern MY_PATTERN = Pattern.compile(PARAMETERPATTERN);
        Matcher matcher = MY_PATTERN.matcher(statement);
        while (matcher.find()) {
            this.parameters.add(matcher.group().replaceAll("\"", ""));
        }
    }

    private String removeParametersFromStatement(String statement) {
        try {
            return Arrays.asList(statement.split(PARAMETERPATTERN)).stream().map(BjoernTextParser::parseText).collect(Collectors.joining(""));
        }
        catch (NullPointerException e) {
            System.out.println(statement);
            throw e;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof BjoernStatement) {
            BjoernStatement compareableStatement = (BjoernStatement)obj;
            return Objects.equals(compareableStatement.getStatementWithoutParameters(), this.getStatementWithoutParameters());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.statementWithoutParameters.hashCode();
    }

    public String getPrimitiveStatement() {
        return this.primitiveStatement;
    }

    public String getStatementWithoutParameters() {
        return this.statementWithoutParameters;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void setPrimitiveStatement(String primitiveStatement) {
        this.primitiveStatement = primitiveStatement;
    }

    public void setStatementWithoutParameters(String statementWithoutParameters) {
        this.statementWithoutParameters = statementWithoutParameters;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public String toString() {
        return "BjoernStatement(primitiveStatement=" + this.getPrimitiveStatement() + ", statementWithoutParameters=" + this.getStatementWithoutParameters() + ", parameters=" + this.getParameters() + ")";
    }
}

