/*
 * Decompiled with CFR 0.152.
 */
package de.mehtrick.bjoern.base;

import de.mehtrick.bjoern.base.BjoernMissingPropertyException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;

public class BjoernGeneratorConfig {
    private final String PROPERTY_PACKAGE = "package";
    private final String PROPERTY_FOLDER = "folder";
    private final String PROPERTY_PATH = "path";
    private final String PROPERTY_GENDIR = "gendir";
    private final String PROPERTY_EXTENDED_TESTCLASS = "extendedTestclass";
    private final String PROPERTY_DOCDIR = "docdir";
    private final String PROPERTY_TEMPLATE = "template";
    private final String PROPERTY_TEMPLATE_FOLDER = "templateFolder";
    private final String PROPERTY_DOC_EXTENSION = "docExtension";
    private final String PROPERTY_ENCODING = "encoding";
    private String path;
    private String folder;
    private String pckg;
    private String gendir;
    private String extendedTestclass;
    private String docdir;
    private String template = "/asciidoc.ftlh";
    private String templateFolder;
    private String docExtension = "adoc";
    private Charset encoding = StandardCharsets.UTF_8;

    public BjoernGeneratorConfig() {
    }

    public BjoernGeneratorConfig(String[] args) {
        this.setPath(this.findPropertyInArgs("path", args));
        this.setFolder(this.findPropertyInArgs("folder", args));
        this.setPckg(this.findPropertyInArgs("package", args));
        this.setGendir(this.findPropertyInArgs("gendir", args));
        this.setExtendedTestclass(this.findPropertyInArgs("extendedTestclass", args));
        this.setDocdir(this.findPropertyInArgs("docdir", args));
        this.setTemplate(this.findPropertyInArgs("template", args));
        this.setTemplateFolder(this.findPropertyInArgs("templateFolder", args));
        this.setDocExtension(this.findPropertyInArgs("docExtension", args));
        this.setEncoding(this.findPropertyInArgs("encoding", args));
    }

    public void validate() throws BjoernMissingPropertyException {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.path, this.folder})) {
            throw new BjoernMissingPropertyException("Please configure a path or folder");
        }
    }

    protected String findPropertyInArgs(String propertyname, String[] args) {
        for (String arg : args) {
            if (!arg.startsWith(propertyname + "=")) continue;
            return StringUtils.substringAfter((String)arg, (String)"=");
        }
        return null;
    }

    public boolean isFoldersSet() {
        return this.folder != null;
    }

    public String getPath() {
        return this.path;
    }

    public String getPckg() {
        return this.pckg;
    }

    public void setPckg(String pckg) {
        this.pckg = pckg;
    }

    public String getGendir() {
        return this.gendir;
    }

    public void setGendir(String gendir) {
        this.gendir = gendir;
    }

    public String getExtendedTestclass() {
        return this.extendedTestclass;
    }

    public void setExtendedTestclass(String extendedTestclass) {
        this.extendedTestclass = extendedTestclass;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        if (folder != null && !folder.isEmpty()) {
            this.folder = folder;
        }
    }

    public String getDocdir() {
        return this.docdir;
    }

    public void setDocdir(String docdir) {
        this.docdir = docdir;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        if (StringUtils.isNotBlank((CharSequence)template)) {
            this.template = template;
        }
    }

    public String getDocExtension() {
        return this.docExtension;
    }

    public void setDocExtension(String docExtension) {
        if (StringUtils.isNotBlank((CharSequence)docExtension)) {
            this.docExtension = docExtension;
        }
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getTemplateFolder() {
        return this.templateFolder;
    }

    public void setTemplateFolder(String templateFolder) {
        this.templateFolder = templateFolder;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        if (StringUtils.isNotBlank((CharSequence)encoding)) {
            this.encoding = Charset.forName(encoding);
        }
    }
}

