/*
 * Decompiled with CFR 0.152.
 */
package etm.core.util;

import etm.core.util.LogAdapter;
import java.io.PrintWriter;
import java.io.StringWriter;

class DefaultLogAdapter
implements LogAdapter {
    private static final int DEBUG = 500;
    private static final int INFO = 400;
    private static final int WARN = 300;
    private static final int ERROR = 200;
    private static final int FATAL = 100;
    private static int logLevel = 400;
    private String clazzName;

    public DefaultLogAdapter(Class aClazz) {
        int i = aClazz.getName().lastIndexOf(46);
        this.clazzName = "[" + aClazz.getName().substring(i + 1) + "] ";
    }

    public void debug(String message) {
        if (logLevel >= 500) {
            System.out.println("[DEBUG] " + this.clazzName + message);
        }
    }

    public void info(String message) {
        if (logLevel >= 400) {
            System.out.println("[INFO ] " + this.clazzName + message);
        }
    }

    public void warn(String message, Throwable t) {
        if (logLevel >= 300) {
            System.err.println("[WARN ] " + this.clazzName + message + this.getThrowable(t));
        }
    }

    public void warn(String message) {
        if (logLevel >= 300) {
            System.out.println("[WARN ] " + this.clazzName + message);
        }
    }

    public void error(String message, Throwable t) {
        if (logLevel >= 200) {
            System.err.println("[ERROR] " + this.clazzName + message + this.getThrowable(t));
        }
    }

    public void fatal(String message, Throwable t) {
        if (logLevel >= 100) {
            System.err.println("[FATAL] " + this.clazzName + message + this.getThrowable(t));
        }
    }

    private String getThrowable(Throwable t) {
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    static {
        String s = System.getProperty("jetm.log.level");
        if (s != null) {
            if ("debug".equalsIgnoreCase(s)) {
                logLevel = 500;
            } else if ("info".equalsIgnoreCase(s)) {
                logLevel = 400;
            } else if ("warn".equalsIgnoreCase(s)) {
                logLevel = 300;
            } else if ("error".equalsIgnoreCase(s)) {
                logLevel = 200;
            } else if ("fatal".equalsIgnoreCase(s)) {
                logLevel = 100;
            } else {
                System.err.println("Unsupported log level " + logLevel);
            }
        }
    }
}

