/*
 * Decompiled with CFR 0.152.
 */
package mServer.tool;

import etm.core.configuration.EtmManager;
import etm.core.monitor.EtmMonitor;
import etm.core.monitor.EtmPoint;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import mServer.daten.MserverDatenUpload;
import mServer.daten.MserverSearchTask;
import mServer.tool.MserverDaten;
import mServer.tool.MserverKonstanten;
import mServer.tool.MserverLog;

public class MserverXmlSchreiben {
    private static final EtmMonitor etmMonitor = EtmManager.getEtmMonitor();
    private static XMLOutputFactory outFactory;
    private static XMLStreamWriter writer;
    private static OutputStreamWriter out;

    public static void xmlMusterDatenSchreiben() {
        EtmPoint performancePoint = etmMonitor.createPoint("MserverXmlSchreiben:xmlMusterDatenSchreiben");
        try {
            String datei = MserverDaten.getKonfigDatei() + "_Muster";
            MserverLog.systemMeldung("Daten Schreiben");
            File file = new File(datei);
            MserverLog.systemMeldung("Start Schreiben nach: " + datei);
            outFactory = XMLOutputFactory.newInstance();
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
            writer = outFactory.createXMLStreamWriter(out);
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeCharacters("\n");
            writer.writeStartElement("MServer");
            writer.writeCharacters("\n");
            MserverXmlSchreiben.xmlSchreibenDaten("system", MserverKonstanten.SYSTEM_COLUMN_NAMES, MserverDaten.system);
            MserverXmlSchreiben.xmlSchreibenDaten("suchen", MserverSearchTask.SUCHEN_COLUMN_NAMES, new MserverSearchTask().arr);
            MserverXmlSchreiben.xmlSchreibenDaten("upload", MserverDatenUpload.UPLOAD_COLUMN_NAMES, new MserverDatenUpload().arr);
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
            writer.close();
            MserverLog.systemMeldung("geschrieben!");
        }
        catch (Exception ex) {
            MserverLog.fehlerMeldung(645421039, MserverXmlSchreiben.class.getName(), "xmlDatenSchreiben", ex);
        }
        performancePoint.collect();
    }

    private static void xmlSchreibenDaten(String xmlName, String[] xmlSpalten, String[] datenArray) {
        EtmPoint performancePoint = etmMonitor.createPoint("MserverXmlSchreiben:xmlSchreibenDaten");
        int xmlMax = datenArray.length;
        try {
            writer.writeStartElement(xmlName);
            writer.writeCharacters("\n");
            for (int i = 0; i < xmlMax; ++i) {
                writer.writeCharacters("\t");
                writer.writeStartElement(xmlSpalten[i]);
                writer.writeCharacters(datenArray[i]);
                writer.writeEndElement();
                writer.writeCharacters("\n");
            }
            writer.writeEndElement();
            writer.writeCharacters("\n");
        }
        catch (Exception ex) {
            MserverLog.fehlerMeldung(102365897, MserverLog.class.getName(), "xmlSchreibenDaten", ex);
        }
        performancePoint.collect();
    }

    static {
        out = null;
    }
}

