/*
 * Decompiled with CFR 0.152.
 */
package mServer.tool;

import de.mediathekview.mlib.tool.Functions;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MserverDatumZeit {
    private static final Logger LOG = LogManager.getLogger(MserverDatumZeit.class);
    private static final SimpleDateFormat SDF_DATUM_ZEIT = new SimpleDateFormat("dd.MM.yyyy  HH:mm:ss");
    private static final SimpleDateFormat SDF_DATUM = new SimpleDateFormat("dd.MM.yyyy");
    private static final SimpleDateFormat SDF_DATUM_YYYY_MM_DD = new SimpleDateFormat("yyyy.MM.dd");
    private static final FastDateFormat FDF_OUT_TIME = FastDateFormat.getInstance((String)"HH:mm:ss");
    private static final FastDateFormat FDF_OUT_DAY = FastDateFormat.getInstance((String)"dd.MM.yyyy");

    public static String getJetzt() {
        return SDF_DATUM_ZEIT.format(new Date());
    }

    public static String getHeute() {
        return SDF_DATUM.format(new Date());
    }

    public static long getSecondsUntilNextDay() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime future = LocalDateTime.of(LocalDate.now(), LocalTime.MIDNIGHT).plusDays(1L);
        Duration duration = Duration.between(now, future);
        return duration.getSeconds();
    }

    public static String getHeute_yyyy_MM_dd() {
        return SDF_DATUM_YYYY_MM_DD.format(new Date());
    }

    public static String getNameAkt(String path) {
        if (path.isEmpty()) {
            return "";
        }
        return Functions.addsPfad(path, "Filmliste-" + new SimpleDateFormat("yyyy-MM-dd").format(new Date()) + ".xz");
    }

    public static String formatDate(String dateValue, FastDateFormat sdf) {
        try {
            return FDF_OUT_DAY.format(sdf.parse(dateValue));
        }
        catch (ParseException ex) {
            LOG.debug(String.format("Fehler beim Parsen des Datums %s: %s", dateValue, ex.getMessage()));
            return "";
        }
    }

    public static String formatTime(String dateValue, FastDateFormat sdf) {
        try {
            return FDF_OUT_TIME.format(sdf.parse(dateValue));
        }
        catch (ParseException ex) {
            LOG.debug(String.format("Fehler beim Parsen des Datums %s: %s", dateValue, ex.getMessage()));
            return "";
        }
    }
}

