/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.phoenix;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import mServer.crawler.sender.phoenix.UrlParseException;

public final class UrlUtils {
    private static final String WRONG_PARAMETER_START = "?&";
    private static final String REGEX_ESCAPOR = "\\";
    private static final String PARAMETER_PATTERN = "%s=%s";
    private static final String URL_PARAMETER_SEPPERATOR = "&";
    private static final String URL_TO_PARAMETERS_SPLITTERATOR = "?";
    private static final String URL_PARAMETER_REPLACEMENT_REGEX_PATTERN = "%s=[^&]*";

    private UrlUtils() {
    }

    public static String addDomainIfMissing(String aUrl, String aDomain) {
        if (aUrl != null && !aUrl.isEmpty() && aUrl.startsWith("/")) {
            return aDomain + aUrl;
        }
        return aUrl;
    }

    public static String addProtocolIfMissing(String aUrl, String aProtocol) {
        if (aUrl != null && aUrl.startsWith("//")) {
            return aProtocol + aUrl;
        }
        return aUrl;
    }

    public static String changeOrAddParameter(String aUrl, String aParameter, String aValue) {
        StringBuilder newUrlBuilder = new StringBuilder();
        String[] splittedUrl = aUrl.split("\\?");
        newUrlBuilder.append(splittedUrl[0]);
        if (splittedUrl.length == 2) {
            String cleanedParameters = splittedUrl[1] + URL_TO_PARAMETERS_SPLITTERATOR.replaceAll(String.format(URL_PARAMETER_REPLACEMENT_REGEX_PATTERN, aParameter), "").replaceAll("\\?&", URL_TO_PARAMETERS_SPLITTERATOR);
            newUrlBuilder.append(URL_TO_PARAMETERS_SPLITTERATOR);
            newUrlBuilder.append(cleanedParameters);
            if (!cleanedParameters.endsWith(URL_PARAMETER_SEPPERATOR) && !cleanedParameters.isEmpty()) {
                newUrlBuilder.append(URL_PARAMETER_SEPPERATOR);
            }
        } else {
            newUrlBuilder.append(URL_TO_PARAMETERS_SPLITTERATOR);
        }
        newUrlBuilder.append(String.format(PARAMETER_PATTERN, aParameter, aValue));
        return newUrlBuilder.toString();
    }

    public static boolean existsUrl(String aUrl) {
        try {
            URL url = new URL(aUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("HEAD");
            connection.connect();
            return connection.getResponseCode() == 200;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String getBaseUrl(String aUrl) {
        int index;
        if (aUrl != null && (index = (index = aUrl.indexOf("//")) > 0 ? aUrl.indexOf(47, index + 2) : aUrl.indexOf(47)) > 0) {
            return aUrl.substring(0, index);
        }
        return aUrl;
    }

    public static Optional<String> getFileName(String aUrl) {
        String file;
        int index;
        if (aUrl != null && (index = aUrl.lastIndexOf(47)) > 0 && (file = aUrl.substring(index + 1)).contains(".")) {
            return Optional.of(file);
        }
        return Optional.empty();
    }

    public static Optional<String> getFileType(String aUrl) {
        int index;
        if (aUrl != null && (index = aUrl.lastIndexOf(46)) > 0) {
            return Optional.of(aUrl.substring(index + 1));
        }
        return Optional.empty();
    }

    public static Optional<String> getProtocol(String aUrl) {
        int index;
        if (aUrl != null && (index = aUrl.indexOf("//")) > 0) {
            String protocol = aUrl.substring(0, index);
            return Optional.of(protocol);
        }
        return Optional.empty();
    }

    public static Optional<String> getUrlParameterValue(String aUrl, String aParameterName) throws UrlParseException {
        Map<String, String> parameters;
        if (aUrl != null && (parameters = UrlUtils.getUrlParameters(aUrl)).containsKey(aParameterName)) {
            return Optional.of(parameters.get(aParameterName));
        }
        return Optional.empty();
    }

    private static Map<String, String> getUrlParameters(String aUrl) throws UrlParseException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        int indexParameterStart = aUrl.indexOf(63);
        if (indexParameterStart > 0) {
            String[] parameterArray;
            String parameterPart = aUrl.substring(indexParameterStart + 1);
            for (String parameter : parameterArray = parameterPart.split(URL_PARAMETER_SEPPERATOR)) {
                String[] parts = parameter.split("=");
                if (parts.length != 2) {
                    throw new UrlParseException("Invalid url paramters: " + aUrl);
                }
                parameters.put(parts[0], parts[1]);
            }
        }
        return parameters;
    }
}

