/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.phoenix;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.tool.Log;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import java.util.concurrent.TimeUnit;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.sender.MediathekReader;
import mServer.crawler.sender.MediathekZdf;
import mServer.crawler.sender.orf.CrawlerUrlDTO;
import mServer.crawler.sender.phoenix.tasks.PhoenixFilmDetailTask;
import mServer.crawler.sender.phoenix.tasks.PhoenixOverviewTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhoenixCrawler
extends MediathekReader {
    private static final Logger LOG = LogManager.getLogger(PhoenixCrawler.class);
    public static final String SENDERNAME = "PHOENIX";
    private final ForkJoinPool forkJoinPool = new ForkJoinPool(Runtime.getRuntime().availableProcessors() * 4);

    public PhoenixCrawler(FilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 0, 1, startPrio);
    }

    @Override
    protected void addToList() {
        this.meldungStart();
        try {
            RecursiveTask<Set<DatenFilm>> filmTask = this.createCrawlerTask();
            Set<DatenFilm> films = this.forkJoinPool.invoke(filmTask);
            Log.sysLog("PH\u00d6NIX Filme einsortieren...");
            films.forEach(film -> {
                if (!Config.getStop()) {
                    MediathekZdf.urlTauschen(film, film.getUrl(), this.mlibFilmeSuchen);
                    this.addFilm((DatenFilm)film);
                }
            });
            Log.sysLog("PH\u00d6NIX Film einsortieren fertig");
        }
        finally {
            this.shutdownAndAwaitTermination(this.forkJoinPool, 60L, TimeUnit.SECONDS);
        }
        Log.sysLog("PH\u00d6NIX fertig");
        this.meldungThreadUndFertig();
    }

    void shutdownAndAwaitTermination(ExecutorService pool, long delay, TimeUnit delayUnit) {
        pool.shutdown();
        Log.sysLog("PH\u00d6NIX shutdown pool...");
        try {
            if (!pool.awaitTermination(delay, delayUnit)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(delay, delayUnit)) {
                    Log.sysLog("PH\u00d6NIX: Pool nicht beendet");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    protected RecursiveTask<Set<DatenFilm>> createCrawlerTask() {
        ConcurrentLinkedQueue<CrawlerUrlDTO> shows = new ConcurrentLinkedQueue<CrawlerUrlDTO>();
        try {
            shows.addAll(this.getShows());
            Log.sysLog("PH\u00d6NIX Anzahl: " + shows.size());
            this.meldungAddMax(shows.size());
            return new PhoenixFilmDetailTask(this, shows, Optional.empty(), "https://www.phoenix.de", "https://tmd.phoenix.de");
        }
        catch (InterruptedException | ExecutionException ex) {
            LOG.fatal("Exception in Ph\u00f6nix crawler.", (Throwable)ex);
            return null;
        }
    }

    private Collection<CrawlerUrlDTO> getShows() throws ExecutionException, InterruptedException {
        CrawlerUrlDTO url = new CrawlerUrlDTO("https://www.phoenix.de/response/template/sendungseite_overview_json");
        ConcurrentLinkedQueue<CrawlerUrlDTO> queue = new ConcurrentLinkedQueue<CrawlerUrlDTO>();
        queue.add(url);
        Set<CrawlerUrlDTO> overviewUrls = this.loadOverviewPages(queue);
        ConcurrentLinkedQueue<CrawlerUrlDTO> queue1 = new ConcurrentLinkedQueue<CrawlerUrlDTO>();
        queue1.addAll(overviewUrls);
        Set<CrawlerUrlDTO> filmUrls = this.loadOverviewPages(queue1);
        return filmUrls;
    }

    private Set<CrawlerUrlDTO> loadOverviewPages(ConcurrentLinkedQueue<CrawlerUrlDTO> aQueue) throws ExecutionException, InterruptedException {
        PhoenixOverviewTask overviewTask = new PhoenixOverviewTask(this, aQueue, Optional.empty(), "https://www.phoenix.de");
        Set<CrawlerUrlDTO> urls = this.forkJoinPool.submit(overviewTask).get();
        return urls;
    }
}

