/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.orf.tasks;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RecursiveTask;
import mServer.crawler.sender.MediathekReader;

public abstract class AbstractRecursivConverterTask<T, D>
extends RecursiveTask<Set<T>> {
    private static final long serialVersionUID = 8416254950859957820L;
    private final ConcurrentLinkedQueue<D> elementsToProcess;
    protected transient MediathekReader crawler;
    protected transient Set<T> taskResults;

    public AbstractRecursivConverterTask(MediathekReader aCrawler, ConcurrentLinkedQueue<D> aUrlToCrawlDTOs) {
        this.crawler = aCrawler;
        this.elementsToProcess = aUrlToCrawlDTOs;
        this.taskResults = ConcurrentHashMap.newKeySet();
    }

    private ConcurrentLinkedQueue<D> createSubSet(ConcurrentLinkedQueue<D> aBaseQueue) {
        int halfSize = aBaseQueue.size() / 2;
        ConcurrentLinkedQueue<D> elementsToCompute = new ConcurrentLinkedQueue<D>();
        for (int i = 0; i < halfSize; ++i) {
            elementsToCompute.offer(aBaseQueue.poll());
        }
        return elementsToCompute;
    }

    private void processElements(ConcurrentLinkedQueue<D> aElementsToProcess) {
        D elementToProcess;
        while ((elementToProcess = aElementsToProcess.poll()) != null) {
            this.processElement(elementToProcess);
        }
    }

    @Override
    protected Set<T> compute() {
        if (this.elementsToProcess.size() <= this.getMaxElementsToProcess()) {
            this.processElements(this.elementsToProcess);
        } else {
            AbstractRecursivConverterTask<T, D> rightTask = this.createNewOwnInstance(this.createSubSet(this.elementsToProcess));
            AbstractRecursivConverterTask<T, D> leftTask = this.createNewOwnInstance(this.elementsToProcess);
            leftTask.fork();
            this.taskResults.addAll((Collection<T>)rightTask.compute());
            this.taskResults.addAll((Collection)leftTask.join());
        }
        return this.taskResults;
    }

    protected abstract AbstractRecursivConverterTask<T, D> createNewOwnInstance(ConcurrentLinkedQueue<D> var1);

    protected abstract Integer getMaxElementsToProcess();

    protected abstract void processElement(D var1);
}

