/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.arte;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.ListeFilme;
import de.mediathekview.mlib.tool.Log;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import mServer.crawler.CrawlerTool;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.sender.MediathekReader;
import mServer.crawler.sender.arte.ArteCategoryFilmListDeserializer;
import mServer.crawler.sender.arte.ArteCategoryFilmsDTO;
import mServer.crawler.sender.arte.ArteDatenFilmDeserializer;
import mServer.crawler.sender.arte.ArteHttpClient;
import mServer.crawler.sender.arte.ArteProgramIdToDatenFilmCallable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MediathekArte_de
extends MediathekReader {
    private static final Logger LOG = LogManager.getLogger(MediathekArte_de.class);
    private static final String SENDERNAME = "ARTE.DE";
    private static final String ARTE_API_TAG_URL_PATTERN = "https://api.arte.tv/api/opa/v3/videos?channel=%s&arteSchedulingDay=%s";
    private static final String URL_SUBCATEGORY = "https://www.arte.tv/guide/api/api/zones/%s/videos_subcategory/?id=%s&page=%s&limit=100";
    private static final String[] SUBCATEGORIES = new String[]{"AJO", "AUV", "KUL", "DCY", "ENQ", "JUN", "ACC", "CMG", "FLM", "CMU", "MCL", "CHU", "FIC", "SES", "ART", "POP", "IDE", "ADS", "CLA", "JAZ", "MUA", "MUD", "OPE", "ENB", "ENN", "SAN", "TEC", "ATA", "EVA", "NEA", "VIA", "CIV", "LGP", "XXE"};
    private static final DateTimeFormatter ARTE_API_DATEFORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    protected String LANG_CODE = "de";
    protected String URL_CONCERT = "http://concert.arte.tv/de/videos/all";
    protected String URL_CONCERT_NOT_CONTAIN = "-STF";
    protected String TIME_1 = "<li>Sendetermine:</li>";
    protected String TIME_2 = "um";

    public MediathekArte_de(FilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 2, 200, startPrio);
    }

    public MediathekArte_de(FilmeSuchen ssearch, int startPrio, String name) {
        super(ssearch, name, 2, 200, startPrio);
    }

    @Override
    public void addToList() {
        this.meldungStart();
        if (Config.getStop()) {
            this.meldungThreadUndFertig();
        } else if (CrawlerTool.loadLongMax()) {
            this.addCategories();
            this.meldungAddMax(this.listeThemen.size());
            for (int t = 0; t < this.getMaxThreadLaufen(); ++t) {
                CategoryLoader th = new CategoryLoader();
                th.setName(this.getSendername() + t);
                th.start();
            }
        } else {
            this.addTage();
            this.meldungAddMax(this.listeThemen.size());
            for (int t = 0; t < this.getMaxThreadLaufen(); ++t) {
                ThemaLaden th = new ThemaLaden();
                th.setName(this.getSendername() + t);
                th.start();
            }
        }
    }

    private void addCategories() {
        for (String subCategory : SUBCATEGORIES) {
            String subCategoryUrl = String.format(URL_SUBCATEGORY, this.LANG_CODE.toLowerCase(), subCategory, 1);
            this.listeThemen.add(new String[]{subCategory, subCategoryUrl});
        }
    }

    private void addTage() {
        for (int i = 0; i <= 14; ++i) {
            String u = String.format(ARTE_API_TAG_URL_PATTERN, this.LANG_CODE.toUpperCase(), LocalDate.now().minusDays(i).format(ARTE_API_DATEFORMATTER));
            this.listeThemen.add(new String[]{u});
        }
    }

    class CategoryLoader
    extends Thread {
        CategoryLoader() {
        }

        @Override
        public void run() {
            try {
                String[] link;
                MediathekArte_de.this.meldungAddThread();
                while (!Config.getStop() && (link = MediathekArte_de.this.listeThemen.getListeThemen()) != null) {
                    MediathekArte_de.this.meldungProgress(link[0] + "/" + link[1]);
                    this.loadSubCategory(link[0], link[1]);
                }
            }
            catch (Exception ex) {
                Log.errorLog(894330854, ex, "");
            }
            MediathekArte_de.this.meldungThreadUndFertig();
        }

        private void loadSubCategory(String aCategory, String aUrl) {
            Gson gson = new GsonBuilder().registerTypeAdapter(ArteCategoryFilmsDTO.class, (Object)new ArteCategoryFilmListDeserializer()).create();
            int i = 2;
            ArteCategoryFilmsDTO dto = this.loadSubCategoryPage(gson, aUrl);
            if (dto != null) {
                ArteCategoryFilmsDTO nextDto = dto;
                while (nextDto != null && nextDto.hasNextPage()) {
                    String url = String.format(MediathekArte_de.URL_SUBCATEGORY, MediathekArte_de.this.LANG_CODE.toLowerCase(), aCategory, i);
                    nextDto = this.loadSubCategoryPage(gson, url);
                    if (nextDto != null) {
                        nextDto.getProgramIds().forEach(programId -> dto.addProgramId((String)programId));
                    }
                    ++i;
                }
                ListeFilme loadedFilme = this.loadPrograms(dto);
                loadedFilme.forEach(film -> MediathekArte_de.this.addFilm(film));
            }
        }

        private ListeFilme loadPrograms(ArteCategoryFilmsDTO dto) {
            ListeFilme listeFilme = new ListeFilme();
            ArrayList futureFilme = new ArrayList();
            dto.getProgramIds().forEach(programId -> {
                try {
                    futureFilme.add(new ArteProgramIdToDatenFilmCallable((String)programId, MediathekArte_de.this.LANG_CODE, MediathekArte_de.this.getSendername()).call());
                }
                catch (Exception exception) {
                    LOG.error("Es ist ein Fehler beim lesen der Arte Filme aufgetreten.", (Throwable)exception);
                }
            });
            CopyOnWriteArrayList finishedFilme = new CopyOnWriteArrayList();
            futureFilme.parallelStream().forEach(finishedFilm -> {
                try {
                    if (finishedFilm != null) {
                        finishedFilme.add(finishedFilm);
                    }
                }
                catch (Exception exception) {
                    LOG.error("Es ist ein Fehler beim lesen der Arte Filme aufgetreten.", (Throwable)exception);
                }
            });
            listeFilme.addAll(finishedFilme);
            return listeFilme;
        }

        private ArteCategoryFilmsDTO loadSubCategoryPage(Gson gson, String aUrl) {
            return ArteHttpClient.executeRequest(LOG, gson, aUrl, ArteCategoryFilmsDTO.class);
        }
    }

    class ThemaLaden
    extends Thread {
        ThemaLaden() {
        }

        @Override
        public void run() {
            try {
                String[] link;
                MediathekArte_de.this.meldungAddThread();
                while (!Config.getStop() && (link = MediathekArte_de.this.listeThemen.getListeThemen()) != null) {
                    MediathekArte_de.this.meldungProgress(link[0]);
                    this.addFilmeForTag(link[0]);
                }
            }
            catch (Exception ex) {
                Log.errorLog(894330854, ex, "");
            }
            MediathekArte_de.this.meldungThreadUndFertig();
        }

        private void addFilmeForTag(String aUrl) {
            Gson gson = new GsonBuilder().registerTypeAdapter(ListeFilme.class, (Object)new ArteDatenFilmDeserializer(MediathekArte_de.this.LANG_CODE, MediathekArte_de.this.getSendername())).create();
            ListeFilme loadedFilme = ArteHttpClient.executeRequest(LOG, gson, aUrl, ListeFilme.class);
            if (loadedFilme != null) {
                loadedFilme.forEach(film -> MediathekArte_de.this.addFilm(film));
            }
        }
    }
}

