/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.tool.Log;
import de.mediathekview.mlib.tool.MSStringBuilder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import mServer.crawler.CrawlerTool;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.GetUrl;
import mServer.crawler.sender.MediathekReader;
import mServer.tool.MserverDaten;
import org.apache.commons.lang3.time.FastDateFormat;

public class MediathekNdr
extends MediathekReader
implements Runnable {
    public static final String SENDERNAME = "NDR";
    private MSStringBuilder seiteAlle = new MSStringBuilder(65536);

    public MediathekNdr(FilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 2, 50, startPrio);
    }

    @Override
    protected void addToList() {
        String ADRESSE = "https://www.ndr.de/mediathek/sendungen_a-z/index.html";
        String MUSTER_URL1 = "<li><a href=\"/mediathek/mediatheksuche105_broadcast-";
        this.listeThemen.clear();
        this.meldungStart();
        MSStringBuilder seite = new MSStringBuilder(65536);
        GetUrl getUrlIo = new GetUrl(this.getWartenSeiteLaden());
        seite = getUrlIo.getUri(SENDERNAME, "https://www.ndr.de/mediathek/sendungen_a-z/index.html", StandardCharsets.UTF_8, 5, seite, "");
        int pos = 0;
        String url = "";
        String thema = "";
        while ((pos = seite.indexOf("<li><a href=\"/mediathek/mediatheksuche105_broadcast-", pos)) != -1) {
            try {
                int pos1 = pos += "<li><a href=\"/mediathek/mediatheksuche105_broadcast-".length();
                int pos2 = seite.indexOf("\"", pos);
                if (pos2 != -1) {
                    url = seite.substring(pos1, pos2);
                }
                pos1 = seite.indexOf(">", pos);
                pos2 = seite.indexOf("<", pos);
                if (pos1 != -1 && pos2 != -1 && pos1 < pos2) {
                    thema = seite.substring(pos1 + 1, pos2);
                }
                if (url.isEmpty()) {
                    Log.errorLog(210367600, "keine Url");
                    continue;
                }
                String url_ = "https://www.ndr.de/mediathek/mediatheksuche105_broadcast-" + url;
                String[] add = new String[]{url_, thema};
                if (CrawlerTool.loadLongMax()) {
                    if (this.alleSeiteSuchen(url_, thema)) continue;
                    this.listeThemen.addUrl(add);
                    continue;
                }
                this.listeThemen.addUrl(add);
            }
            catch (Exception ex) {
                Log.errorLog(332945670, ex);
            }
        }
        FastDateFormat formatter1 = FastDateFormat.getInstance((String)"yyyy-MM-dd");
        FastDateFormat formatter2 = FastDateFormat.getInstance((String)"dd.MM.yyyy");
        int maxTage = CrawlerTool.loadLongMax() ? 30 : 20;
        for (int i = 0; i < maxTage; ++i) {
            String URL2 = "https://www.ndr.de/mediathek/sendung_verpasst/epg1490_date-";
            String tag = formatter1.format(new Date().getTime() - (long)(86400000 * i));
            String date = formatter2.format(new Date().getTime() - (long)(86400000 * i));
            String urlString = "https://www.ndr.de/mediathek/sendung_verpasst/epg1490_date-" + tag + "_display-all.html";
            this.listeThemen.addUrl(new String[]{urlString, date});
        }
        if (Config.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.isEmpty()) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.listeThemen.size());
            for (int t = 0; t < this.getMaxThreadLaufen(); ++t) {
                ThemaLaden th = new ThemaLaden();
                th.setName(SENDERNAME + t);
                th.start();
            }
        }
    }

    private boolean alleSeiteSuchen(String strUrlFeed, String tthema) {
        boolean ret = false;
        GetUrl getUrlIo = new GetUrl(this.getWartenSeiteLaden());
        this.seiteAlle = getUrlIo.getUri(SENDERNAME, strUrlFeed, StandardCharsets.UTF_8, 3, this.seiteAlle, "Thema: " + tthema);
        int pos1 = 0;
        int anz2 = 0;
        try {
            String WEITER = " title=\"Zeige Seite ";
            while ((pos1 = this.seiteAlle.indexOf(" title=\"Zeige Seite ", pos1)) != -1) {
                int pos2 = this.seiteAlle.indexOf("\"", pos1 += " title=\"Zeige Seite ".length());
                if (pos2 == -1) continue;
                String anz = this.seiteAlle.substring(pos1, pos2);
                try {
                    int anz1 = Integer.parseInt(anz);
                    if (anz2 >= anz1) continue;
                    anz2 = anz1;
                }
                catch (Exception ex) {
                    Log.errorLog(643208979, strUrlFeed);
                }
            }
            for (int i = 2; i <= anz2 && i <= 10; ++i) {
                String url_ = strUrlFeed.replace(".html", "_page-" + i + ".html");
                this.listeThemen.addUrl(new String[]{url_, tthema});
                ret = true;
            }
        }
        catch (Exception ex) {
            Log.errorLog(913047821, strUrlFeed);
        }
        return ret;
    }

    private class ThemaLaden
    extends Thread {
        private final GetUrl getUrl;
        private MSStringBuilder seite1;
        private MSStringBuilder seite2;
        private MSStringBuilder seite3;
        private final ArrayList<String> liste;

        private ThemaLaden() {
            this.getUrl = new GetUrl(MediathekNdr.this.getWartenSeiteLaden());
            this.seite1 = new MSStringBuilder(65536);
            this.seite2 = new MSStringBuilder(65536);
            this.seite3 = new MSStringBuilder(65536);
            this.liste = new ArrayList();
        }

        @Override
        public void run() {
            try {
                String[] link;
                MediathekNdr.this.meldungAddThread();
                while (!Config.getStop() && (link = MediathekNdr.this.listeThemen.getListeThemen()) != null) {
                    try {
                        MediathekNdr.this.meldungProgress(link[1]);
                        this.feedEinerSeiteSuchen(link[0], link[1]);
                    }
                    catch (Exception ex) {
                        Log.errorLog(336901211, ex);
                    }
                }
            }
            catch (Exception ex) {
                Log.errorLog(554632590, ex);
            }
            MediathekNdr.this.meldungThreadUndFertig();
        }

        private long convertDuration(String duration, String strUrlFeed) {
            long durationInSeconds = 0L;
            try {
                if (!duration.isEmpty()) {
                    String[] parts = duration.split(":");
                    long power = 1L;
                    durationInSeconds = 0L;
                    for (int i = parts.length - 1; i >= 0; --i) {
                        durationInSeconds += Long.parseLong(parts[i]) * power;
                        power *= 60L;
                    }
                }
            }
            catch (NumberFormatException ex) {
                if (MserverDaten.debug) {
                    Log.errorLog(369015497, (Exception)ex, strUrlFeed);
                }
            }
            catch (Exception ex) {
                Log.errorLog(369015497, ex, strUrlFeed);
            }
            return durationInSeconds;
        }

        private void feedEinerSeiteSuchen(String strUrlFeed, String tthema) {
            String MUSTER_URL = "<a href=\"";
            GetUrl getUrlIo = new GetUrl(MediathekNdr.this.getWartenSeiteLaden());
            this.seite1 = getUrlIo.getUri(MediathekNdr.SENDERNAME, strUrlFeed, StandardCharsets.UTF_8, 3, this.seite1, "Thema: " + tthema);
            int pos = 0;
            String thema = tthema;
            String datum = "";
            String zeit = "";
            boolean tage = false;
            try {
                String muster;
                MediathekNdr.this.meldung(strUrlFeed);
                if (this.seite1.indexOf("<strong class=\"time\">") != -1) {
                    muster = "<strong class=\"time\">";
                    tage = true;
                } else {
                    muster = "<span class=\"icon icon_video\"></span>";
                }
                while (!Config.getStop() && (pos = this.seite1.indexOf(muster, pos)) != -1) {
                    long durationInSeconds;
                    String duration;
                    String tmp;
                    String titel;
                    String url = this.seite1.extract("<a href=\"", "\"", pos += muster.length());
                    if (url.isEmpty()) {
                        Log.errorLog(659210274, "keine Url feedEinerSeiteSuchen" + strUrlFeed);
                        continue;
                    }
                    if (!url.startsWith("http")) {
                        url = "https://www.ndr.de" + url;
                    }
                    if (tage) {
                        thema = this.seite1.extract("<a href=\"", " title=\"", "\"", pos, 0, "");
                        titel = this.seite1.extract("<a href=\"", ">", "<", pos, 0, "");
                        if (titel.contains("(Wdh.)")) continue;
                        if (thema.equals(titel)) {
                            if (thema.contains(" - ")) {
                                thema = thema.substring(0, thema.indexOf(" - ")).trim();
                                titel = titel.substring(titel.indexOf(" - "));
                                titel = titel.replace(" - ", "").trim();
                            } else {
                                String subtitle = this.seite1.extract("class=\"subtitle\">", "<", pos).trim();
                                if (!subtitle.isEmpty()) {
                                    titel = subtitle;
                                }
                            }
                        }
                    } else {
                        titel = this.seite1.extract(" title=\"", "\"", pos);
                        titel = titel.replace("Zum Video:", "").trim();
                    }
                    if (tage) {
                        tmp = this.seite1.substring(pos, this.seite1.indexOf("<", pos));
                        datum = tthema;
                        try {
                            Date filmDate = FastDateFormat.getInstance((String)"HH:mm").parse(tmp);
                            zeit = FastDateFormat.getInstance((String)"HH:mm:ss").format(filmDate);
                        }
                        catch (Exception ex) {
                            Log.errorLog(795623017, "convertDatum: " + strUrlFeed);
                        }
                    } else {
                        tmp = this.seite1.extract("<div class=\"subline date\">", "<", pos);
                        String[] dateValues = this.parseDateTime(tmp, strUrlFeed);
                        datum = dateValues[0];
                        zeit = dateValues[1];
                    }
                    if (tage) {
                        duration = this.seite1.extract("\"L&auml;nge\"></span>", "<", pos).trim();
                        durationInSeconds = this.convertDuration(duration, strUrlFeed);
                    } else {
                        duration = this.seite1.extract("Video (", ")", pos);
                        duration = duration.replace("min", "").trim();
                        durationInSeconds = this.convertDuration(duration, strUrlFeed);
                    }
                    this.filmSuchen_1(strUrlFeed, thema, titel, url, datum, zeit, durationInSeconds);
                }
            }
            catch (Exception ex) {
                Log.errorLog(693219870, strUrlFeed);
            }
        }

        private String[] parseDateTime(String dateTimeValue, String strUrlFeed) {
            String[] dateValues = new String[]{"", ""};
            String dateTime = dateTimeValue.replace("Uhr", "").trim();
            if (!dateTime.isEmpty()) {
                try {
                    Date filmDate = FastDateFormat.getInstance((String)"dd.MM.yyyy HH:mm").parse(dateTime);
                    dateValues[0] = FastDateFormat.getInstance((String)"dd.MM.yyyy").format(filmDate);
                    dateValues[1] = FastDateFormat.getInstance((String)"HH:mm:ss").format(filmDate);
                }
                catch (Exception ex) {
                    Log.errorLog(623657941, "convertDatum: " + strUrlFeed);
                }
            }
            return dateValues;
        }

        private void filmSuchen_1(String strUrlThema, String thema, String titel, String filmWebsite, String datum, String zeit, long durationInSeconds) {
            this.seite2 = this.getUrl.getUri_Utf(MediathekNdr.SENDERNAME, filmWebsite, this.seite2, "strUrlThema: " + strUrlThema);
            String description = this.extractDescription(this.seite2);
            String subtitle = this.seite2.extract(",tracks: [{ src: \"", "\"");
            if (!subtitle.isEmpty()) {
                subtitle = "https://www.ndr.de" + subtitle;
            }
            MediathekNdr.this.meldung(filmWebsite);
            try {
                String json;
                String tmp;
                int pos1;
                if (datum.isEmpty() && (pos1 = (tmp = this.seite2.extract("<span itemprop=\"datePublished\"", "</")).indexOf(">")) != -1) {
                    tmp = tmp.substring(pos1 + 1, tmp.length());
                    String[] dateValues = this.parseDateTime(tmp, strUrlThema);
                    datum = dateValues[0];
                    zeit = dateValues[1];
                }
                if (!(json = this.seite2.extract("<meta itemprop=\"embedURL\" content=\"", "\"")).isEmpty()) {
                    json = json.replace("-player.html", "-ardjson.json");
                    this.filmSuchen_2(strUrlThema, thema, titel, filmWebsite, json, datum, zeit, durationInSeconds, description, subtitle);
                } else {
                    Log.errorLog(915230214, "auch keine Url: " + filmWebsite);
                }
            }
            catch (Exception ex) {
                Log.errorLog(699830157, ex);
            }
        }

        private void filmSuchen_2(String strUrlThema, String thema, String titel, String filmWebsite, String json, String datum, String zeit, long durationInSeconds, String description, String subtitle) {
            this.seite3 = this.getUrl.getUri_Utf(MediathekNdr.SENDERNAME, json, this.seite3, "strUrlThema: " + strUrlThema);
            String url_hd = "";
            String url_xl = "";
            String url_m = "";
            this.seite3.extractList("", "", "\"_stream\": \"https://mediandr", "\"", "https://mediandr", this.liste);
            for (String s : this.liste) {
                if (s.endsWith(".hd.mp4")) {
                    url_hd = s;
                    continue;
                }
                if (s.endsWith(".hq.mp4")) {
                    url_xl = s;
                    continue;
                }
                if (!s.endsWith(".hi.mp4")) continue;
                url_m = s;
            }
            this.liste.clear();
            if (url_xl.isEmpty()) {
                url_xl = url_m;
                url_m = "";
            }
            String http = "http:";
            String https = "https:";
            url_hd = url_hd.replaceFirst("https:", "http:");
            url_xl = url_xl.replaceFirst("https:", "http:");
            url_m = url_m.replaceFirst("https:", "http:");
            if (subtitle.isEmpty()) {
                subtitle = this.seite3.extract("\"_subtitleUrl\":", "\"/", "\"", "https://www.ndr.de/");
            }
            if (!url_xl.isEmpty()) {
                DatenFilm film = new DatenFilm(MediathekNdr.SENDERNAME, thema, filmWebsite, titel, url_xl, "", datum, zeit, durationInSeconds, description);
                if (!subtitle.isEmpty()) {
                    CrawlerTool.addUrlSubtitle(film, subtitle);
                }
                if (!url_hd.isEmpty()) {
                    CrawlerTool.addUrlHd(film, url_hd, "");
                }
                if (!url_m.isEmpty()) {
                    CrawlerTool.addUrlKlein(film, url_m, "");
                }
                MediathekNdr.this.addFilm(film);
            } else {
                Log.errorLog(915234210, "keine URL im json: " + filmWebsite);
            }
        }

        private String extractDescription(MSStringBuilder page) {
            String desc = this.extractString(page, "<meta property=\"og:description\" content=\"", "\"");
            if (desc == null) {
                return "";
            }
            return desc;
        }

        private String extractString(MSStringBuilder source, String startMarker, String endMarker) {
            int start = source.indexOf(startMarker);
            if (start == -1) {
                return null;
            }
            int end = source.indexOf(endMarker, start += startMarker.length());
            if (end == -1) {
                return null;
            }
            return source.substring(start, end);
        }
    }
}

