/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class DelayUndoManager
extends UndoManager {
    private static final long serialVersionUID = -2910365359251677780L;
    private int _delay = 500;
    private CompoundEdit _cache;
    private static final Logger LOGGER = Logger.getLogger(DelayUndoManager.class.getName());
    protected Timer _timer;

    public DelayUndoManager() {
    }

    public DelayUndoManager(int delay) {
        this._delay = delay;
    }

    public boolean isCacheEmpty() {
        return this._cache == null;
    }

    public synchronized void commitCache() {
        if (this._cache != null) {
            this._cache.end();
            this.addEditWithoutCaching();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Commit cache: " + this._cache);
            }
            this._cache = null;
        }
    }

    public void addEditWithoutCaching() {
        DelayUndoManager.super.addEdit(this._cache);
    }

    public synchronized void discardCache() {
        this._cache = null;
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
        }
    }

    public synchronized boolean addEdit(UndoableEdit anEdit) {
        if (this._cache == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Create cache: " + anEdit);
            }
            this._cache = new CompoundEdit();
            boolean ret = this._cache.addEdit(anEdit);
            if (ret) {
                this._timer = new Timer(this._delay, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        DelayUndoManager.this.commitCache();
                    }
                });
                this._timer.setRepeats(false);
                this._timer.start();
            }
            return ret;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Add to cache: " + anEdit);
        }
        if (this._timer != null) {
            this._timer.restart();
        }
        return this._cache.addEdit(anEdit);
    }

    public synchronized boolean canUndo() {
        this.commitCache();
        return super.canUndo();
    }

    public synchronized boolean canRedo() {
        this.commitCache();
        return super.canRedo();
    }

    public synchronized void undo() throws CannotUndoException {
        this.commitCache();
        super.undo();
    }

    public synchronized void redo() throws CannotRedoException {
        this.commitCache();
        super.redo();
    }

    public synchronized void discardAllEdits() {
        super.discardAllEdits();
        this.discardCache();
    }
}

