/*
 * Decompiled with CFR 0.152.
 */
package mServer.daten;

import java.text.SimpleDateFormat;
import java.util.Date;
import mServer.tool.MserverDatumZeit;
import mServer.tool.MserverLog;

public class MserverSearchTask {
    public static final String SUCHEN_UPDATE = "kurz";
    public static final String SUCHEN_LONG = "lang";
    public static final String SUCHEN_MAX = "max";
    public static final String SUCHEN_NEU = "neu";
    public static final String SUCHEN_WANN_SOFORT = "sofort";
    public static final String SUCHEN_SENDER_WIE = "suchen-sender-wie";
    public static final int SUCHEN_SENDER_WIE_NR = 0;
    public static final String SUCHEN_LISTE_WIE = "suchen-liste-wie";
    public static final int SUCHEN_LISTE_WIE_NR = 1;
    public static final String SUCHEN_WANN = "suchen-wann";
    public static final int SUCHEN_WANN_NR = 2;
    public static final String SUCHEN_SENDER = "suchen-sender";
    public static final int SUCHEN_SENDER_NR = 3;
    public static final String SUCHEN_ORG_LISTE = "suchen-org-liste";
    public static final int SUCHEN_ORG_LISTE_NR = 4;
    public static final String SUCHEN_MAX_WAIT = "suchen-max-warten";
    public static final int SUCHEN_MAX_WAIT_NR = 5;
    public static final String SUCHEN = "suchen";
    public static final int SUCHEN_MAX_ELEM = 6;
    public static final String[] SUCHEN_COLUMN_NAMES = new String[]{"suchen-sender-wie", "suchen-liste-wie", "suchen-wann", "suchen-sender", "suchen-org-liste", "suchen-max-warten"};
    public String[] arr = new String[6];

    public MserverSearchTask() {
        for (int i = 0; i < this.arr.length; ++i) {
            this.arr[i] = "";
        }
    }

    public void meldungNaechsterStart() {
        MserverLog.systemMeldung("naechster Start: " + this.arr[2]);
    }

    public void meldungStart() {
        MserverLog.systemMeldung("Starten: " + this.arr[2]);
        MserverLog.systemMeldung("Suchen Sender wie:  " + this.arr[0]);
        MserverLog.systemMeldung("Suchen Liste wie:  " + (this.updateFilmliste() ? "nur ein Update" : "neue Filmliste"));
        if (!this.arr[3].equals("")) {
            MserverLog.systemMeldung("Sender:  " + this.arr[3]);
        }
    }

    public int getWaitTime() {
        int waitTime = 60;
        if (this.arr[5].isEmpty()) {
            switch (this.loadHow()) {
                case 0: {
                    waitTime = 60;
                    break;
                }
                case 1: {
                    waitTime = 160;
                    break;
                }
                case 2: {
                    waitTime = 240;
                }
            }
        } else {
            try {
                waitTime = Integer.parseInt(this.arr[5]);
            }
            catch (Exception ignore) {
                waitTime = 60;
            }
        }
        return waitTime;
    }

    public boolean sofortSuchen() {
        return this.arr[2].equals(SUCHEN_WANN_SOFORT);
    }

    public boolean spaeter(MserverSearchTask d) {
        if (this.sofortSuchen()) {
            return false;
        }
        return this.getTimeHeute().compareTo(d.getTimeHeute()) > 0;
    }

    public boolean orgListeAnlegen() {
        return Boolean.parseBoolean(this.arr[4]);
    }

    public Date getTimeHeute() {
        SimpleDateFormat sdf_zeit = new SimpleDateFormat("dd.MM.yyyy__HH:mm");
        try {
            return sdf_zeit.parse(MserverDatumZeit.getHeute() + "__" + this.arr[2]);
        }
        catch (Exception ex) {
            Date ret = null;
            MserverLog.fehlerMeldung(825439079, MserverSearchTask.class.getName(), "getTime", ex);
            return ret;
        }
    }

    public int loadHow() {
        int ret;
        switch (this.arr[0]) {
            case "lang": {
                ret = 1;
                break;
            }
            case "max": {
                ret = 2;
                break;
            }
            default: {
                ret = 0;
            }
        }
        return ret;
    }

    public boolean updateFilmliste() {
        boolean ret = true;
        if (this.arr[1].equals(SUCHEN_NEU)) {
            ret = false;
        }
        return ret;
    }

    public boolean starten() {
        if (this.sofortSuchen()) {
            return true;
        }
        Date now = new Date();
        return this.getTimeHeute().compareTo(now) <= 0;
    }
}

