/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.phoenix.tasks;

import de.mediathekview.mlib.Config;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import mServer.crawler.sender.MediathekReader;
import mServer.crawler.sender.orf.CrawlerUrlDTO;
import mServer.crawler.sender.orf.tasks.AbstractUrlTask;
import org.glassfish.jersey.client.filter.EncodingFilter;
import org.glassfish.jersey.message.DeflateEncoder;
import org.glassfish.jersey.message.GZipEncoder;

public abstract class AbstractRestTask<T, D extends CrawlerUrlDTO>
extends AbstractUrlTask<T, D> {
    private static final long serialVersionUID = 2590729915326002860L;
    protected static final String ENCODING_GZIP = "gzip";
    protected static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    protected static final String HEADER_AUTHORIZATION = "Authorization";
    protected static final String AUTHORIZATION_BEARER = "Bearer ";
    protected final transient Optional<String> authKey;
    private final Client client;

    public AbstractRestTask(MediathekReader aCrawler, ConcurrentLinkedQueue<D> aUrlToCrawlDTOs, Optional<String> aAuthKey) {
        super(aCrawler, aUrlToCrawlDTOs);
        this.authKey = aAuthKey;
        this.client = ClientBuilder.newClient();
        this.client.register(EncodingFilter.class);
        this.client.register(GZipEncoder.class);
        this.client.register(DeflateEncoder.class);
    }

    protected abstract void processRestTarget(D var1, WebTarget var2);

    @Override
    protected void processElement(D aDTO) {
        if (Config.getStop()) {
            return;
        }
        WebTarget target = this.createWebTarget(((CrawlerUrlDTO)aDTO).getUrl());
        this.processRestTarget(aDTO, target);
    }

    protected WebTarget createWebTarget(String aUrl) {
        return this.client.target(aUrl);
    }
}

