/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.br;

import com.google.gson.JsonSyntaxException;
import java.net.MalformedURLException;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.RunSender;
import mServer.crawler.sender.MediathekReader;
import mServer.crawler.sender.br.BrWebAccessExecution;
import org.apache.logging.log4j.Logger;

public class BrWebAccessHelper {
    private BrWebAccessHelper() {
    }

    public static void handleWebAccessExecution(Logger log, MediathekReader crawler, BrWebAccessExecution action) {
        try {
            action.run();
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            BrWebAccessHelper.handleError("The json syntax for the BR task to get all Sendungen has an error.", (Exception)((Object)jsonSyntaxException), log, crawler);
        }
        catch (MalformedURLException malformedURLException) {
            BrWebAccessHelper.handleError("The URL given to WebAccess is not valid.", malformedURLException, log, crawler);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BrWebAccessHelper.handleError("URL given to the WebAccess was Null", illegalArgumentException, log, crawler);
        }
    }

    private static void handleError(String errorMessage, Exception e, Logger log, MediathekReader crawler) {
        log.error(errorMessage, (Throwable)e);
        FilmeSuchen.listeSenderLaufen.inc(crawler.getSendername(), RunSender.Count.FEHLER);
    }
}

