/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.tool.Log;
import de.mediathekview.mlib.tool.MSStringBuilder;
import de.mediathekview.mlib.tool.MVHttpClient;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.RunSender;
import mServer.tool.MserverDaten;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class GetUrl {
    private static final int PAUSE = 1000;
    public static boolean showLoadTime = false;
    private long delayVal = TimeUnit.MILLISECONDS.convert(50L, TimeUnit.MILLISECONDS);

    public GetUrl() {
    }

    public GetUrl(long delay) {
        this.setDelay(delay, TimeUnit.MILLISECONDS);
    }

    public void setDelay(long delay, TimeUnit delayUnit) {
        this.delayVal = TimeUnit.MILLISECONDS.convert(delay, delayUnit);
    }

    @Deprecated
    public MSStringBuilder getUri_Utf(String sender, String addr, MSStringBuilder seite, String meldung) {
        return this.getUri(sender, addr, StandardCharsets.UTF_8, 1, seite, meldung);
    }

    public MSStringBuilder getUri_Iso(String sender, String addr, MSStringBuilder seite, String meldung) {
        return this.getUri(sender, addr, StandardCharsets.ISO_8859_1, 1, seite, meldung);
    }

    public MSStringBuilder getUri(String sender, String addr, Charset encoding, int maxVersuche, MSStringBuilder seite, String meldung) {
        return this.getUri(sender, addr, encoding, maxVersuche, seite, meldung, "");
    }

    public MSStringBuilder getUriWithDelay(String sender, String addr, Charset encoding, int maxVersuche, MSStringBuilder seite, String meldung, long delay, TimeUnit delayUnit) {
        this.setDelay(delay, delayUnit);
        return this.getUri(sender, addr, encoding, maxVersuche, seite, meldung);
    }

    public MSStringBuilder getUri(String sender, String addr, Charset encoding, int maxVersuche, MSStringBuilder seite, String meldung, String token) {
        int aktVer = 0;
        do {
            ++aktVer;
            try {
                boolean letzterVersuch;
                if (this.delayVal > 0L) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(this.delayVal);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (aktVer > 1) {
                    TimeUnit.MILLISECONDS.sleep(1000L);
                }
                if ((seite = this.getUriNew(sender, addr, seite, encoding, meldung, maxVersuche, letzterVersuch = aktVer >= maxVersuche, token)).length() > 0) {
                    if (Config.debug && aktVer > 1) {
                        String text = sender + " [" + aktVer + '/' + maxVersuche + "] ~~~> " + addr;
                        Log.sysLog(text);
                    }
                    FilmeSuchen.listeSenderLaufen.inc(sender, RunSender.Count.ANZAHL);
                    return seite;
                }
                FilmeSuchen.listeSenderLaufen.inc(sender, RunSender.Count.FEHLVERSUCHE);
                FilmeSuchen.listeSenderLaufen.inc(sender, RunSender.Count.WARTEZEIT_FEHLVERSUCHE, this.delayVal);
                if (!letzterVersuch) continue;
                FilmeSuchen.listeSenderLaufen.inc(sender, RunSender.Count.FEHLER);
            }
            catch (Exception ex) {
                Log.errorLog(698963200, ex, sender);
            }
        } while (!Config.getStop() && aktVer < maxVersuche);
        return seite;
    }

    private void updateStatistics(String sender, long bytesWritten) {
        FilmeSuchen.listeSenderLaufen.inc(sender, RunSender.Count.SUM_DATA_BYTE, bytesWritten);
        FilmeSuchen.listeSenderLaufen.inc(sender, RunSender.Count.SUM_TRAFFIC_BYTE, bytesWritten);
        FilmeSuchen.listeSenderLaufen.inc(sender, RunSender.Count.SUM_TRAFFIC_LOADART_NIX, bytesWritten);
    }

    private long transferData(ResponseBody body, Charset encoding, MSStringBuilder seite) throws IOException {
        long load = 0L;
        if (body.contentType() != null) {
            try (InputStreamReader inReader = new InputStreamReader(body.byteStream(), encoding);){
                int n;
                char[] buffer = new char[16384];
                while (!Config.getStop() && (n = inReader.read(buffer)) != -1) {
                    seite.append(buffer, 0, n);
                    load += (long)n;
                }
            }
        }
        return load;
    }

    private long webCall(Request request, MSStringBuilder seite, Charset encoding) throws IOException {
        long load = 0L;
        try (Response response = MVHttpClient.getInstance().getHttpClient().newCall(request).execute();
             ResponseBody body = response.body();){
            if (response.isSuccessful()) {
                load = this.transferData(body, encoding, seite);
            }
        }
        return load;
    }

    private Request.Builder createRequestBuilder(String addr, String token) {
        Request.Builder builder = new Request.Builder().url(addr);
        if (!token.isEmpty()) {
            builder.addHeader("Api-Auth", "Bearer " + token);
        }
        return builder;
    }

    private MSStringBuilder getUriNew(String sender, String addr, MSStringBuilder seite, Charset encoding, String meldung, int versuch, boolean lVersuch, String token) {
        long load = 0L;
        try {
            seite.setLength(0);
            if (MserverDaten.debug) {
                Log.sysLog("Durchsuche: " + addr);
            }
            Request.Builder builder = this.createRequestBuilder(addr, token);
            load = this.webCall(builder.build(), seite, encoding);
        }
        catch (SocketTimeoutException | UnknownHostException ignored) {
            if (MserverDaten.debug) {
                this.printDebugMessage(meldung, addr, sender, versuch, ignored);
            }
        }
        catch (IOException ex) {
            if (lVersuch) {
                this.printDebugMessage(meldung, addr, sender, versuch, ex);
            }
        }
        catch (Exception ex) {
            Log.errorLog(973969801, ex, "");
        }
        this.updateStatistics(sender, load);
        return seite;
    }

    private void printDebugMessage(String meldung, String addr, String sender, int versuch, Exception ex) {
        String[] text = meldung.isEmpty() ? new String[]{"", "Sender: " + sender + " - Versuche: " + versuch, "URL: " + addr} : new String[]{"", "Sender: " + sender + " - Versuche: " + versuch, "URL: " + addr, meldung};
        switch (ex.getMessage()) {
            case "Read timed out": {
                text[0] = "TimeOut: ";
                Log.errorLog(502739817, text);
                break;
            }
            default: {
                Log.errorLog(379861049, ex, text);
            }
        }
    }
}

