/*
 * Decompiled with CFR 0.152.
 */
package etm.core.configuration;

import etm.core.configuration.EtmConfigurationException;
import etm.core.configuration.EtmManager;
import etm.core.configuration.EtmMonitorConfig;
import etm.core.configuration.EtmMonitorFactory;
import etm.core.configuration.XmlConfigParser;
import etm.core.monitor.EtmMonitor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class XmlEtmConfigurator {
    private XmlEtmConfigurator() {
    }

    public static void configure(String config) {
        ByteArrayInputStream inStream = null;
        try {
            inStream = new ByteArrayInputStream(config.getBytes());
            XmlEtmConfigurator.doConfigure(inStream);
        }
        catch (EtmConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EtmConfigurationException(e);
        }
        finally {
            if (inStream != null) {
                try {
                    ((InputStream)inStream).close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void configure(URL configLocation) {
        InputStream inStream = null;
        try {
            inStream = configLocation.openStream();
            XmlEtmConfigurator.doConfigure(inStream);
        }
        catch (EtmConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EtmConfigurationException(e);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void configure(InputStream in) {
        try {
            XmlEtmConfigurator.doConfigure(in);
        }
        catch (EtmConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EtmConfigurationException(e);
        }
    }

    public static void configure(File file) {
        try {
            XmlEtmConfigurator.configure(file.toURL());
        }
        catch (MalformedURLException e) {
            throw new EtmConfigurationException(e);
        }
    }

    private static void doConfigure(InputStream in) throws Exception {
        EtmMonitorConfig monitorConfig = XmlConfigParser.extractConfig(in);
        EtmMonitor etmMonitor = EtmMonitorFactory.createEtmMonitor(monitorConfig);
        EtmManager.configure(etmMonitor);
    }
}

