/*
 * Decompiled with CFR 0.152.
 */
package etm.core.jmx;

import etm.core.aggregation.Aggregate;
import etm.core.jmx.JmxSupport;
import etm.core.metadata.AggregatorMetaData;
import etm.core.metadata.EtmMonitorMetaData;
import etm.core.monitor.EtmException;
import etm.core.monitor.EtmMonitor;
import etm.core.renderer.MeasurementRenderer;
import etm.core.renderer.SimpleTextRenderer;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanConstructorInfo;
import javax.management.openmbean.OpenMBeanInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public class EtmMonitorMBean
extends JmxSupport
implements DynamicMBean {
    private EtmMonitor etmMonitor;
    private String measurementDomain;
    private OpenMBeanInfoSupport activeInfo;
    private OpenMBeanInfoSupport inactiveInfo;
    protected TabularType tabularType;

    public EtmMonitorMBean(EtmMonitor aEtmMonitor, String aMeasurementDomain) throws OpenDataException {
        this.etmMonitor = aEtmMonitor;
        this.measurementDomain = aMeasurementDomain;
        String mbeanClassName = this.etmMonitor.getClass().getName();
        EtmMonitorMetaData etmMonitorMetaData = this.etmMonitor.getMetaData();
        AggregatorMetaData metaData = etmMonitorMetaData.getAggregatorMetaData();
        String chain = metaData.getImplementationClass().getName();
        for (metaData = metaData.getNestedMetaData(); metaData != null; metaData = metaData.getNestedMetaData()) {
            chain = chain + "," + metaData.getImplementationClass().getName();
        }
        String description = etmMonitorMetaData.getDescription() + " Configuration: Aggregator Chain (" + chain + "), Timer Implementation (" + etmMonitorMetaData.getTimerMetaData().getImplementationClass().getClass().getName() + ") ]";
        this.tabularType = new TabularType("performanceDetails", "blubbler", new CompositeType("etmPoint", "blabla", new String[]{"name", "measurements", "average", "min", "max", "total", "objectname"}, new String[]{"EtmPoint name", "Number of measurements", "Average time (ms)", "Minimum time (ms)", "Maximum Time (ms)", "Total Time (ms)", "JMX ObjectName"}, new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.OBJECTNAME}), new String[]{"name", "measurements", "average", "min", "max", "total", "objectname"});
        this.activeInfo = new OpenMBeanInfoSupport(mbeanClassName, description, this.getAttributeInfos(), new OpenMBeanConstructorInfo[0], this.getActiveMonitorOperation(), new MBeanNotificationInfo[0]);
        this.inactiveInfo = new OpenMBeanInfoSupport(mbeanClassName, description, this.getAttributeInfos(), new OpenMBeanConstructorInfo[0], this.getInactiveMonitorOperation(), new MBeanNotificationInfo[0]);
    }

    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if ("started".equals(string)) {
            return this.etmMonitor.isStarted() ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("collecting".equals(string)) {
            return this.etmMonitor.isCollecting() ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("startDate".equals(string)) {
            return this.etmMonitor.getMetaData().getStartTime();
        }
        if ("lastResetDate".equals(string)) {
            return this.etmMonitor.getMetaData().getLastResetTime();
        }
        throw new AttributeNotFoundException(string);
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new AttributeNotFoundException(attribute.getName());
    }

    public AttributeList getAttributes(String[] strings) {
        AttributeList list = new AttributeList();
        for (int i = 0; i < strings.length; ++i) {
            try {
                list.add(i, new Attribute(strings[i], this.getAttribute(strings[i])));
                continue;
            }
            catch (Exception e) {
                list.add(i, new Attribute(strings[i], null));
            }
        }
        return list;
    }

    public AttributeList setAttributes(AttributeList attributeList) {
        return new AttributeList();
    }

    public Object invoke(String string, Object[] objects, String[] strings) throws MBeanException, ReflectionException {
        if ("disableCollection".equals(string)) {
            this.etmMonitor.disableCollection();
        } else if ("enableCollection".equals(string)) {
            this.etmMonitor.enableCollection();
        } else if ("reset".equals(string)) {
            this.etmMonitor.reset();
        } else {
            if ("renderResultsAsText".equals(string)) {
                return this.renderResultsAsText();
            }
            if ("results".equals(string)) {
                return this.renderResults();
            }
        }
        return null;
    }

    public MBeanInfo getMBeanInfo() {
        if (this.etmMonitor.isCollecting()) {
            return this.activeInfo;
        }
        return this.inactiveInfo;
    }

    private TabularData renderResults() {
        final TabularDataSupport data = new TabularDataSupport(this.tabularType);
        this.etmMonitor.render(new MeasurementRenderer(){

            public void render(Map points) {
                Iterator iterator = points.values().iterator();
                while (iterator.hasNext()) {
                    Aggregate aggregate = (Aggregate)iterator.next();
                    try {
                        data.put(new CompositeDataSupport(EtmMonitorMBean.this.tabularType.getRowType(), new String[]{"name", "measurements", "average", "min", "max", "total", "objectname"}, new Object[]{aggregate.getName(), new Long(aggregate.getMeasurements()), new Double(aggregate.getAverage()), new Double(aggregate.getMin()), new Double(aggregate.getMax()), new Double(aggregate.getTotal()), EtmMonitorMBean.this.calculateObjectName(EtmMonitorMBean.this.measurementDomain, aggregate)}));
                    }
                    catch (Exception e) {
                        throw new EtmException(e);
                    }
                }
            }
        });
        return data;
    }

    public String renderResultsAsText() {
        StringWriter writer = new StringWriter();
        SimpleTextRenderer renderer = new SimpleTextRenderer(writer);
        this.etmMonitor.render(renderer);
        return writer.toString();
    }

    private OpenMBeanOperationInfo[] getActiveMonitorOperation() {
        try {
            return new OpenMBeanOperationInfoSupport[]{new OpenMBeanOperationInfoSupport("disableCollection", "Disables performance monitoring.", null, SimpleType.VOID, 1), new OpenMBeanOperationInfoSupport("reset", "Resets current performance data.", null, SimpleType.VOID, 1), new OpenMBeanOperationInfoSupport("renderResultsAsText", "Renders aggregated performance statistics in text format", null, SimpleType.STRING, 1), new OpenMBeanOperationInfoSupport("results", "Current top level performance results.", null, this.tabularType, 0)};
        }
        catch (Exception e) {
            throw new EtmException(e.getMessage());
        }
    }

    private OpenMBeanOperationInfo[] getInactiveMonitorOperation() {
        try {
            return new OpenMBeanOperationInfoSupport[]{new OpenMBeanOperationInfoSupport("enableCollection", "Enables performance monitoring.", null, SimpleType.VOID, 1), new OpenMBeanOperationInfoSupport("reset", "Resets current performance data.", null, SimpleType.VOID, 1), new OpenMBeanOperationInfoSupport("renderResultsAsText", "Renders aggregated performance statistics in text format", null, SimpleType.STRING, 1), new OpenMBeanOperationInfoSupport("results", "Current top level performance results.", null, this.tabularType, 0)};
        }
        catch (Exception e) {
            throw new EtmException(e.getMessage());
        }
    }

    private OpenMBeanAttributeInfo[] getAttributeInfos() {
        try {
            return new OpenMBeanAttributeInfoSupport[]{new OpenMBeanAttributeInfoSupport("started", "Whether the monitor is started or not.", SimpleType.BOOLEAN, true, false, true), new OpenMBeanAttributeInfoSupport("collecting", "Whether the monitor is collecting or not.", SimpleType.BOOLEAN, true, false, true), new OpenMBeanAttributeInfoSupport("startDate", "The date the application was started.", SimpleType.DATE, true, false, false), new OpenMBeanAttributeInfoSupport("lastResetDate", "The date the monitor was resetted.", SimpleType.DATE, true, false, false)};
        }
        catch (Exception e) {
            throw new EtmException(e.getMessage());
        }
    }
}

