/*
 * Decompiled with CFR 0.152.
 */
package etm.core.jmx;

import etm.core.aggregation.Aggregate;
import etm.core.aggregation.persistence.PersistentEtmState;
import etm.core.jmx.EtmMonitorMBean;
import etm.core.jmx.EtmPointMBean;
import etm.core.jmx.JmxSupport;
import etm.core.monitor.EtmMonitor;
import etm.core.monitor.event.AggregationListener;
import etm.core.monitor.event.AggregationStateListener;
import etm.core.monitor.event.AggregationStateLoadedEvent;
import etm.core.monitor.event.MonitorResetEvent;
import etm.core.monitor.event.PreMonitorResetEvent;
import etm.core.monitor.event.PreRootResetEvent;
import etm.core.monitor.event.RootCreateEvent;
import etm.core.monitor.event.RootResetEvent;
import etm.core.util.Log;
import etm.core.util.LogAdapter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class AbstractJmxRegistry
extends JmxSupport
implements AggregationStateListener,
AggregationListener {
    private static final LogAdapter log = Log.getLog(class$etm$core$jmx$AbstractJmxRegistry == null ? (class$etm$core$jmx$AbstractJmxRegistry = AbstractJmxRegistry.class$("etm.core.jmx.AbstractJmxRegistry")) : class$etm$core$jmx$AbstractJmxRegistry);
    public static final String DEFAULT_ETM_MONITOR_OBJECT_NAME = "etm.monitor:service=PerformanceMonitor";
    public static final String DEFAULT_ETM_POINT_DOMAIN = "etm.performance";
    protected String monitorObjectName = "etm.monitor:service=PerformanceMonitor";
    protected String measurementDomain = "etm.performance";
    protected String mbeanServerName;
    protected boolean overwrite = false;
    protected MBeanServer mbeanServer;
    protected EtmMonitor etmMonitor;
    private boolean isStopping = true;
    protected EtmMonitorMBean monitorMBean;
    static /* synthetic */ Class class$etm$core$jmx$AbstractJmxRegistry;

    public void setMbeanServerName(String aMbeanServerName) {
        this.mbeanServerName = aMbeanServerName;
    }

    public void setMonitorObjectName(String aMonitorObjectName) {
        if (aMonitorObjectName == null || aMonitorObjectName.trim().length() == 0) {
            throw new IllegalArgumentException("ObjectName for EtmMonitor may not be null or empty ");
        }
        this.monitorObjectName = aMonitorObjectName;
    }

    public void setMeasurementDomain(String aMeasurementDomain) {
        this.measurementDomain = aMeasurementDomain;
    }

    public void setOverwrite(boolean flag) {
        this.overwrite = flag;
    }

    public void start() {
        if (this.mbeanServer == null) {
            try {
                ArrayList<MBeanServer> mbeanServers = MBeanServerFactory.findMBeanServer(this.mbeanServerName);
                if (mbeanServers.size() > 0) {
                    this.mbeanServer = mbeanServers.get(0);
                    ObjectName objectName = new ObjectName(this.monitorObjectName);
                    this.monitorMBean = new EtmMonitorMBean(this.etmMonitor, this.measurementDomain);
                    this.registerMBean(this.mbeanServer, objectName, this.monitorMBean, this.overwrite);
                    this.isStopping = false;
                } else {
                    log.warn("Unable to locate a valid MBeanServer. Disable JMX support.");
                }
            }
            catch (Exception e) {
                log.error("Error while registering EtmMonitorMBean ", e);
            }
        }
    }

    public void stop() {
        this.isStopping = true;
        if (this.mbeanServer != null) {
            try {
                this.deregisterPerformanceResults();
                this.mbeanServer.unregisterMBean(new ObjectName(this.monitorObjectName));
            }
            catch (Exception e) {
                log.warn("Error while unregistering EtmMonitorMBean ", e);
            }
        }
    }

    public void onStateLoaded(AggregationStateLoadedEvent event) {
        if (this.isStopping) {
            return;
        }
        PersistentEtmState persistentEtmState = event.getState();
        Map aggregates = persistentEtmState.getAggregates();
        Iterator iterator = aggregates.values().iterator();
        while (iterator.hasNext()) {
            Aggregate aggregate = (Aggregate)iterator.next();
            try {
                this.registerMBean(this.mbeanServer, this.calculateObjectName(this.measurementDomain, aggregate), new EtmPointMBean(this.etmMonitor, aggregate), this.overwrite);
            }
            catch (JMException e) {
                log.warn("Unable to register EtmPoint " + aggregate.getName(), e);
            }
        }
    }

    public void onRootCreate(RootCreateEvent event) {
        if (this.isStopping) {
            return;
        }
        Aggregate aggregate = event.getAggregate();
        try {
            this.registerMBean(this.mbeanServer, this.calculateObjectName(this.measurementDomain, aggregate), new EtmPointMBean(this.etmMonitor, aggregate), this.overwrite);
        }
        catch (JMException e) {
            log.warn("Unable to register EtmPoint " + aggregate.getName(), e);
        }
    }

    public void onStateReset(MonitorResetEvent event) {
        if (this.isStopping) {
            return;
        }
        try {
            this.deregisterPerformanceResults();
        }
        catch (Exception e) {
            log.warn("Error while deregistering all performance results ", e);
        }
    }

    public void onRootReset(RootResetEvent event) {
    }

    public void preRootReset(PreRootResetEvent event) {
    }

    public void preStateReset(PreMonitorResetEvent event) {
    }

    protected void deregisterPerformanceResults() throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        ObjectName objectName = new ObjectName(this.measurementDomain + ":*");
        Set<ObjectName> set = this.mbeanServer.queryNames(objectName, null);
        Iterator<ObjectName> iterator = set.iterator();
        while (iterator.hasNext()) {
            ObjectName o = iterator.next();
            this.mbeanServer.unregisterMBean(o);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

