/*
 * Decompiled with CFR 0.152.
 */
package etm.core.configuration;

import etm.core.configuration.EtmAggregatorConfig;
import etm.core.configuration.EtmConfigurationException;
import etm.core.configuration.EtmMonitorFactory;
import etm.core.configuration.EtmPluginConfig;
import java.util.ArrayList;
import java.util.List;

public class EtmMonitorConfig {
    private boolean autostart;
    private Class monitorClass = class$etm$core$monitor$NestedMonitor == null ? (class$etm$core$monitor$NestedMonitor = EtmMonitorConfig.class$("etm.core.monitor.NestedMonitor")) : class$etm$core$monitor$NestedMonitor;
    private Class timerClass;
    private EtmAggregatorConfig aggregatorRoot;
    private List etmAggregators;
    private List pluginConfig;
    static /* synthetic */ Class class$etm$core$monitor$NestedMonitor;
    static /* synthetic */ Class class$etm$core$monitor$FlatMonitor;
    static /* synthetic */ Class class$etm$core$monitor$NullMonitor;
    static /* synthetic */ Class class$etm$core$monitor$EtmMonitor;
    static /* synthetic */ Class class$etm$core$timer$DefaultTimer;
    static /* synthetic */ Class class$etm$core$timer$ExecutionTimer;

    public boolean isAutostart() {
        return this.autostart;
    }

    public void setAutostart(boolean aAutostart) {
        this.autostart = aAutostart;
    }

    public Class getMonitorClass() {
        return this.monitorClass;
    }

    public Class getTimerClass() {
        return this.timerClass;
    }

    public List getEtmAggregators() {
        if (this.etmAggregators != null && this.aggregatorRoot == null) {
            throw new EtmConfigurationException("Aggregator root not set.");
        }
        return this.etmAggregators;
    }

    public EtmAggregatorConfig getAggregatorRoot() {
        return this.aggregatorRoot;
    }

    public List getPluginConfig() {
        return this.pluginConfig;
    }

    public void setMonitorType(String monitorType) {
        if ("flat".equalsIgnoreCase(monitorType)) {
            this.monitorClass = class$etm$core$monitor$FlatMonitor == null ? (class$etm$core$monitor$FlatMonitor = EtmMonitorConfig.class$("etm.core.monitor.FlatMonitor")) : class$etm$core$monitor$FlatMonitor;
        } else if ("nested".equalsIgnoreCase(monitorType)) {
            this.monitorClass = class$etm$core$monitor$NestedMonitor == null ? (class$etm$core$monitor$NestedMonitor = EtmMonitorConfig.class$("etm.core.monitor.NestedMonitor")) : class$etm$core$monitor$NestedMonitor;
        } else if ("null".equalsIgnoreCase(monitorType)) {
            this.monitorClass = class$etm$core$monitor$NullMonitor == null ? (class$etm$core$monitor$NullMonitor = EtmMonitorConfig.class$("etm.core.monitor.NullMonitor")) : class$etm$core$monitor$NullMonitor;
        } else {
            Class<?> clazz;
            try {
                clazz = Class.forName(monitorType);
            }
            catch (ClassNotFoundException e) {
                throw new EtmConfigurationException("Unsupported monitor type or invalid monitor class " + monitorType + ".");
            }
            if ((class$etm$core$monitor$EtmMonitor == null ? (class$etm$core$monitor$EtmMonitor = EtmMonitorConfig.class$("etm.core.monitor.EtmMonitor")) : class$etm$core$monitor$EtmMonitor).isAssignableFrom(clazz)) {
                this.monitorClass = clazz;
            } else {
                throw new EtmConfigurationException("Class " + this.monitorClass + " is not a valid EtmMonitor implementation.");
            }
        }
    }

    public void setTimerType(String timerType) {
        if ("default".equalsIgnoreCase(timerType)) {
            this.timerClass = class$etm$core$timer$DefaultTimer == null ? (class$etm$core$timer$DefaultTimer = EtmMonitorConfig.class$("etm.core.timer.DefaultTimer")) : class$etm$core$timer$DefaultTimer;
        } else {
            if ("sun".equalsIgnoreCase(timerType)) {
                try {
                    this.timerClass = Class.forName("etm.core.timer.SunHighResTimer");
                }
                catch (ClassNotFoundException e) {
                    throw new EtmConfigurationException("Sun HigRes Timer not available.");
                }
            }
            if ("jdk50".equalsIgnoreCase(timerType)) {
                try {
                    this.timerClass = Class.forName("etm.core.timer.Java15NanoTimer");
                }
                catch (ClassNotFoundException e) {
                    throw new EtmConfigurationException("Java 5.0 Nano Timer not available.");
                }
            }
            if ("bestAvailable".equalsIgnoreCase(timerType)) {
                this.timerClass = EtmMonitorFactory.bestAvailableTimer().getClass();
            } else {
                Class<?> clazz;
                try {
                    clazz = Class.forName(timerType);
                }
                catch (ClassNotFoundException e) {
                    throw new EtmConfigurationException("Unsupported timer type or invalid timer class " + this.timerClass + " for timer type " + timerType + ".");
                }
                if ((class$etm$core$timer$ExecutionTimer == null ? (class$etm$core$timer$ExecutionTimer = EtmMonitorConfig.class$("etm.core.timer.ExecutionTimer")) : class$etm$core$timer$ExecutionTimer).isAssignableFrom(clazz)) {
                    this.timerClass = clazz;
                } else {
                    throw new EtmConfigurationException("Class " + this.timerClass + " is not a valid ExecutionTimer implementation.");
                }
            }
        }
    }

    public void appendAggregator(EtmAggregatorConfig aAggregatorConfig) {
        if (this.etmAggregators == null) {
            this.etmAggregators = new ArrayList();
        }
        this.etmAggregators.add(aAggregatorConfig);
    }

    public void setAggregatorRoot(EtmAggregatorConfig aRootConfig) {
        this.aggregatorRoot = aRootConfig;
    }

    public void addExtension(EtmPluginConfig aPluginConfig) {
        if (this.pluginConfig == null) {
            this.pluginConfig = new ArrayList();
        }
        this.pluginConfig.add(aPluginConfig);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

