/*
 * Decompiled with CFR 0.152.
 */
package etm.core.aggregation;

import etm.core.aggregation.Aggregate;
import etm.core.monitor.EtmPoint;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class ExecutionAggregate
implements Externalizable,
Aggregate {
    private static final long serialVersionUID = 1L;
    private String name;
    private long measurements = 0L;
    private double min = 0.0;
    private double max = 0.0;
    private double total = 0.0;
    private Map childs;

    public ExecutionAggregate() {
    }

    public ExecutionAggregate(String aName) {
        this.name = aName;
    }

    public String getName() {
        return this.name;
    }

    public double getAverage() {
        if (this.measurements != 0L) {
            return this.total / (double)this.measurements;
        }
        return 0.0;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public long getMeasurements() {
        return this.measurements;
    }

    public double getTotal() {
        return this.total;
    }

    public Map getChilds() {
        return this.childs;
    }

    public boolean hasChilds() {
        return this.childs != null && this.childs.size() > 0;
    }

    public void addTransaction(EtmPoint transaction) {
        double miliseconds = transaction.getTransactionTime();
        ++this.measurements;
        this.total += miliseconds;
        this.max = this.max > miliseconds ? this.max : miliseconds;
        this.min = this.min > miliseconds || this.min == 0.0 ? miliseconds : this.min;
    }

    public void appendPath(LinkedList newTree) {
        EtmPoint current = (EtmPoint)newTree.removeFirst();
        ExecutionAggregate aggregate = this.getChild(current.getName());
        if (newTree.size() == 0) {
            aggregate.addTransaction(current);
        } else {
            aggregate.appendPath(newTree);
        }
    }

    protected void setMeasurements(long aMeasurements) {
        this.measurements = aMeasurements;
    }

    protected void setMin(double aMin) {
        this.min = aMin;
    }

    protected void setMax(double aMax) {
        this.max = aMax;
    }

    protected void setTotal(double aTotal) {
        this.total = aTotal;
    }

    protected void setChilds(Map aChilds) {
        this.childs = aChilds;
    }

    public String toString() {
        return this.name + " -  " + this.measurements + " calls -  " + this.total + "ms total, " + this.min + "ms min, " + this.max + "ms max";
    }

    private ExecutionAggregate getChild(String aName) {
        ExecutionAggregate aggregate;
        if (this.childs == null) {
            this.childs = new HashMap();
        }
        if ((aggregate = (ExecutionAggregate)this.childs.get(aName)) == null) {
            aggregate = new ExecutionAggregate(aName);
            this.childs.put(aName, aggregate);
        }
        return aggregate;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.name);
        out.writeLong(this.measurements);
        out.writeDouble(this.min);
        out.writeDouble(this.max);
        out.writeDouble(this.total);
        out.writeObject(this.childs);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = (String)in.readObject();
        this.measurements = in.readLong();
        this.min = in.readDouble();
        this.max = in.readDouble();
        this.total = in.readDouble();
        this.childs = (Map)in.readObject();
    }

    public void reset() {
        this.measurements = 0L;
        this.min = 0.0;
        this.max = 0.0;
        this.total = 0.0;
        this.childs = null;
    }
}

