/*
 * Decompiled with CFR 0.152.
 */
package etm.core.aggregation;

import etm.core.aggregation.Aggregator;
import etm.core.metadata.AggregatorMetaData;
import etm.core.monitor.EtmMonitorContext;
import etm.core.monitor.EtmPoint;
import etm.core.renderer.MeasurementRenderer;

public class BufferedThresholdAggregator
implements Aggregator {
    private static final String DESCRIPTION = "A buffering aggregator with a threshold of ";
    private static final int DEFAULT_SIZE = 10000;
    private static final int MIN_THRESHOLD = 1000;
    protected final Aggregator delegate;
    protected int threshold = 10000;
    protected BoundedBuffer buffer;
    static /* synthetic */ Class class$etm$core$aggregation$BufferedThresholdAggregator;

    public BufferedThresholdAggregator(Aggregator aAggregator) {
        this.delegate = aAggregator;
    }

    public void setThreshold(int aThreshold) {
        if (aThreshold < 1000) {
            throw new IllegalArgumentException("Thresholds may not be lower than " + this.threshold + ".");
        }
        this.threshold = aThreshold;
    }

    public void add(EtmPoint point) {
        this.buffer.add(point);
    }

    public void flush() {
        this.buffer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Aggregator aggregator = this.delegate;
        synchronized (aggregator) {
            this.delegate.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(String symbolicName) {
        Aggregator aggregator = this.delegate;
        synchronized (aggregator) {
            this.delegate.reset(symbolicName);
        }
    }

    public void render(MeasurementRenderer renderer) {
        this.flush();
        this.delegate.render(renderer);
    }

    public AggregatorMetaData getMetaData() {
        return new AggregatorMetaData(class$etm$core$aggregation$BufferedThresholdAggregator == null ? (class$etm$core$aggregation$BufferedThresholdAggregator = BufferedThresholdAggregator.class$("etm.core.aggregation.BufferedThresholdAggregator")) : class$etm$core$aggregation$BufferedThresholdAggregator, DESCRIPTION + this.threshold, true, this.delegate.getMetaData());
    }

    public void init(EtmMonitorContext ctx) {
        this.delegate.init(ctx);
    }

    public void start() {
        this.delegate.start();
        this.buffer = new BoundedBuffer(this.threshold);
    }

    public void stop() {
        this.flush();
        this.delegate.stop();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class BoundedBuffer {
        private EtmPoint[] buffer;
        private int currentPos = 0;

        public BoundedBuffer(int size) {
            this.buffer = new EtmPoint[size];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(EtmPoint point) {
            EtmPoint[] current;
            int length;
            BoundedBuffer boundedBuffer = this;
            synchronized (boundedBuffer) {
                this.buffer[this.currentPos] = point;
                ++this.currentPos;
                if (this.currentPos < this.buffer.length) {
                    return;
                }
                length = this.currentPos;
                current = this.buffer;
                this.buffer = new EtmPoint[current.length];
                this.currentPos = 0;
            }
            this.doFlush(current, length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            EtmPoint[] current;
            int length;
            BoundedBuffer boundedBuffer = this;
            synchronized (boundedBuffer) {
                length = this.currentPos;
                current = this.buffer;
                this.buffer = new EtmPoint[current.length];
                this.currentPos = 0;
            }
            this.doFlush(current, length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doFlush(EtmPoint[] aCurrent, int aLength) {
            Aggregator aggregator = BufferedThresholdAggregator.this.delegate;
            synchronized (aggregator) {
                for (int i = 0; i < aLength; ++i) {
                    BufferedThresholdAggregator.this.delegate.add(aCurrent[i]);
                }
            }
        }
    }
}

