/*
 * Decompiled with CFR 0.152.
 */
package mServer.upload;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import mServer.daten.MserverDatenUpload;
import mServer.tool.MserverLog;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPReply;

public class MserverFtp {
    private static String server;
    private static String strPort;
    private static String username;
    private static String password;
    private static String srcPathFile;
    private static String destFileName;
    private static MserverDatenUpload datenUpload;
    private static boolean retFtp;

    public static boolean uploadFtp(String srcPathFile_, String destFileName_, MserverDatenUpload datenUpload_) {
        try {
            srcPathFile = srcPathFile_;
            destFileName = destFileName_;
            datenUpload = datenUpload_;
            server = MserverFtp.datenUpload.arr[2];
            strPort = MserverFtp.datenUpload.arr[6];
            username = MserverFtp.datenUpload.arr[3];
            password = MserverFtp.datenUpload.arr[4];
            MserverLog.systemMeldung("");
            MserverLog.systemMeldung("----------------------");
            MserverLog.systemMeldung("Upload start");
            MserverLog.systemMeldung("Server: " + server);
            Thread t = new Thread(new Ftp());
            t.start();
            int warten = 5;
            MserverLog.systemMeldung("Max Laufzeit FTP[Min]: " + warten);
            MserverLog.systemMeldung("-----------------------------------");
            warten = 60000 * warten;
            t.join(warten);
            if (t != null && t.isAlive()) {
                MserverLog.fehlerMeldung(396958702, MserverFtp.class.getName(), "Der letzte FtpUpload l\u00e4uft noch");
                MserverLog.systemMeldung("und wird gekillt");
                t.stop();
                retFtp = false;
            }
        }
        catch (Exception ex) {
            MserverLog.fehlerMeldung(739861047, MserverFtp.class.getName(), "uploadFtp", ex);
        }
        return retFtp;
    }

    static {
        retFtp = false;
    }

    private static class Ftp
    implements Runnable {
        private Ftp() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            int port = 0;
            FTPClient ftp = new FTPClient();
            try {
                if (!strPort.equals("")) {
                    port = Integer.parseInt(strPort);
                }
            }
            catch (Exception ex) {
                MserverLog.fehlerMeldung(101203698, MserverFtp.class.getName(), "uploadFtp", ex);
                port = 0;
            }
            ftp.addProtocolCommandListener(new PrintCommandListener(new PrintWriter(System.out), true));
            try {
                if (port > 0) {
                    ftp.connect(server, port);
                } else {
                    ftp.connect(server);
                }
                MserverLog.debugMeldung("Connected to " + server + " on " + (port > 0 ? port : ftp.getDefaultPort()));
                int reply = ftp.getReplyCode();
                if (!FTPReply.isPositiveCompletion(reply)) {
                    ftp.disconnect();
                    MserverLog.debugMeldung("FTP server refused connection.");
                    return;
                }
            }
            catch (IOException e) {
                if (ftp.isConnected()) {
                    try {
                        ftp.disconnect();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                MserverLog.fehlerMeldung(969363254, MserverFtp.class.getName(), "MS_UploadFtp", (Exception)e);
                return;
            }
            try {
                if (!ftp.login(username, password)) {
                    ftp.logout();
                } else {
                    MserverLog.debugMeldung("Remote system is " + ftp.getSystemType());
                    ftp.setFileType(2);
                    ftp.enterLocalPassiveMode();
                    ftp.setUseEPSVwithIPv4(false);
                    FileInputStream input = new FileInputStream(srcPathFile);
                    String dest = datenUpload.getFilmlisteDestPfadName(destFileName);
                    MserverLog.debugMeldung("Upload Filmliste + rename");
                    String dest_tmp = dest + "__";
                    String dest_old = dest + "_old";
                    ftp.storeFile(dest_tmp, input);
                    MserverLog.debugMeldung("Upload Filmliste " + dest_tmp);
                    ftp.rename(dest, dest_old);
                    MserverLog.debugMeldung("Rename alte Filmliste " + dest);
                    ftp.rename(dest_tmp, dest);
                    MserverLog.debugMeldung("Rename Filmliste " + dest);
                    ((InputStream)input).close();
                    ftp.noop();
                    ftp.logout();
                    retFtp = true;
                }
            }
            catch (FTPConnectionClosedException e) {
                MserverLog.fehlerMeldung(646362014, MserverFtp.class.getName(), "MS_UploadFtp", (Exception)e);
            }
            catch (IOException e) {
                MserverLog.fehlerMeldung(989862047, MserverFtp.class.getName(), "MS_UploadFtp", (Exception)e);
            }
            finally {
                if (ftp.isConnected()) {
                    try {
                        ftp.disconnect();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }
}

