/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.tool.Log;
import de.mediathekview.mlib.tool.MSStringBuilder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import mServer.crawler.CrawlerTool;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.GetUrl;
import mServer.crawler.sender.MediathekReader;

public class MediathekRbb
extends MediathekReader {
    public static final String SENDERNAME = "RBB";

    public MediathekRbb(FilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 2, 100, startPrio);
    }

    @Override
    protected void addToList() {
        MSStringBuilder seite = new MSStringBuilder(65536);
        ArrayList<String> liste = new ArrayList<String>();
        String ADRESSE_1 = "http://mediathek.rbb-online.de/tv/sendungen-a-z?cluster=a-k";
        String ADRESSE_2 = "http://mediathek.rbb-online.de/tv/sendungen-a-z?cluster=l-z";
        String URL2 = "<a href=\"/tv/";
        this.meldungStart();
        try {
            GetUrl getUrlIo = new GetUrl(this.getWartenSeiteLaden());
            seite = getUrlIo.getUri(SENDERNAME, "http://mediathek.rbb-online.de/tv/sendungen-a-z?cluster=a-k", StandardCharsets.UTF_8, 5, seite, "");
            seite.extractList("", "", "<a href=\"/tv/", "\"", "", liste);
            seite = getUrlIo.getUri(SENDERNAME, "http://mediathek.rbb-online.de/tv/sendungen-a-z?cluster=l-z", StandardCharsets.UTF_8, 5, seite, "");
            seite.extractList("", "", "<a href=\"/tv/", "\"", "", liste);
            for (String s : liste) {
                if (s.isEmpty() || !s.contains("documentId=")) continue;
                s = "http://mediathek.rbb-online.de/tv/" + s;
                this.listeThemen.addUrl(new String[]{s});
            }
        }
        catch (Exception ex) {
            Log.errorLog(398214058, ex);
        }
        if (Config.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.isEmpty()) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.listeThemen.size());
            for (int t = 0; t < this.getMaxThreadLaufen(); ++t) {
                Thread th = new Thread(new ThemaLaden(false));
                th.setName(SENDERNAME + t);
                th.start();
            }
            this.meldungAddMax(7);
            ThemaLaden th = new ThemaLaden(true);
            th.setName("RBB_Tage");
            th.start();
        }
    }

    private class ThemaLaden
    extends Thread {
        private boolean addTage = false;
        private MSStringBuilder seite1 = new MSStringBuilder(65536);
        private MSStringBuilder seite2 = new MSStringBuilder(65536);
        private MSStringBuilder seite3 = new MSStringBuilder(65536);

        public ThemaLaden(boolean addTage) {
            this.addTage = addTage;
        }

        @Override
        public void run() {
            try {
                MediathekRbb.this.meldungAddThread();
                if (this.addTage) {
                    this.addTage();
                } else {
                    String[] link;
                    while (!Config.getStop() && (link = MediathekRbb.this.listeThemen.getListeThemen()) != null) {
                        MediathekRbb.this.meldungProgress(link[0]);
                        this.addThema(link[0], true);
                    }
                }
            }
            catch (Exception ex) {
                Log.errorLog(794625882, ex);
            }
            MediathekRbb.this.meldungThreadUndFertig();
        }

        private void addTage() {
            String MUSTER_START = "<h2 class=\"modHeadline\">7 Tage R\u00fcckblick</h2>";
            String MUSTER_URL = "<div class=\"media mediaA\">";
            String URL2 = "<a href=\"/tv/";
            for (int i = 0; i <= 6; ++i) {
                String urlTage = "http://mediathek.rbb-online.de/tv/sendungVerpasst?topRessort=tv&tag=" + i;
                MediathekRbb.this.meldungProgress(urlTage);
                GetUrl getUrlIo = new GetUrl(MediathekRbb.this.getWartenSeiteLaden());
                this.seite1 = getUrlIo.getUri_Utf(MediathekRbb.SENDERNAME, urlTage, this.seite1, "");
                int pos1 = this.seite1.indexOf("<h2 class=\"modHeadline\">7 Tage R\u00fcckblick</h2>");
                while (!Config.getStop() && (pos1 = this.seite1.indexOf("<div class=\"media mediaA\">", pos1)) != -1) {
                    String urlSeite = this.seite1.extract("<a href=\"/tv/", "\"", pos1 += "<div class=\"media mediaA\">".length());
                    if (!urlSeite.isEmpty()) {
                        urlSeite = urlSeite.replaceAll("&amp;", "&");
                        urlSeite = "http://mediathek.rbb-online.de/tv/" + urlSeite;
                        this.addFilme(urlSeite);
                        continue;
                    }
                    Log.errorLog(751203697, "keine URL f\u00fcr: " + urlSeite);
                }
            }
        }

        private void addThema(String url, boolean weiter) {
            try {
                String URL2 = "<a href=\"/tv/";
                String MUSTER_URL = "<div class=\"media mediaA\">";
                GetUrl getUrlIo = new GetUrl(MediathekRbb.this.getWartenSeiteLaden());
                this.seite1 = getUrlIo.getUri_Utf(MediathekRbb.SENDERNAME, url, this.seite1, "");
                int pos1 = this.seite1.indexOf("<div class=\"entry\">");
                while (!Config.getStop() && (pos1 = this.seite1.indexOf("<div class=\"media mediaA\">", pos1)) != -1) {
                    String urlSeite = this.seite1.extract("<a href=\"/tv/", "\"", pos1 += "<div class=\"media mediaA\">".length());
                    if (!urlSeite.isEmpty()) {
                        urlSeite = urlSeite.replaceAll("&amp;", "&");
                        urlSeite = "http://mediathek.rbb-online.de/tv/" + urlSeite;
                        this.addFilme(urlSeite);
                        continue;
                    }
                    Log.errorLog(751203697, "keine URL f\u00fcr: " + url);
                }
                if (weiter && CrawlerTool.loadLongMax()) {
                    for (int i = 2; i < 10; ++i) {
                        if (this.seite1.indexOf("mcontents=page." + i) == -1) continue;
                        this.addThema(url + "&mcontents=page." + i, false);
                    }
                }
            }
            catch (Exception ex) {
                Log.errorLog(541236987, ex);
            }
        }

        private void addFilme(String urlSeite) {
            try {
                String subtitle;
                MediathekRbb.this.meldung(urlSeite);
                String datum = "";
                String zeit = "";
                GetUrl getUrlIo = new GetUrl(MediathekRbb.this.getWartenSeiteLaden());
                this.seite2 = getUrlIo.getUri_Utf(MediathekRbb.SENDERNAME, urlSeite, this.seite2, "");
                String description = this.seite2.extract("<meta name=\"description\" content=\"", "\"");
                String durationInSeconds = this.seite2.extract("<meta property=\"video:duration\" content=\"", "\"");
                long duration = 0L;
                if (!durationInSeconds.isEmpty()) {
                    try {
                        duration = Long.parseLong(durationInSeconds);
                    }
                    catch (Exception ex) {
                        Log.errorLog(200145787, ex);
                        duration = 0L;
                    }
                }
                String title = this.seite2.extract("<meta name=\"dcterms.title\" content=\"", "\"");
                String thema = this.seite2.extract("<meta name=\"dcterms.isPartOf\" content=\"", "\"");
                String sub = this.seite2.extract("<p class=\"subtitle\">", "<");
                if (sub.contains("|")) {
                    datum = sub.substring(0, sub.indexOf(124) - 1);
                    zeit = (datum = datum.substring(datum.indexOf(32)).trim()).substring(datum.indexOf(32)).trim();
                    if (zeit.length() == 5) {
                        zeit = zeit + ":00";
                    }
                    if ((datum = datum.substring(0, datum.indexOf(32)).trim()).length() == 8) {
                        datum = datum.substring(0, 6) + "20" + datum.substring(6);
                    }
                }
                String urlFilm = urlSeite.substring(urlSeite.indexOf("documentId=") + "documentId=".length());
                urlFilm = "http://mediathek.rbb-online.de/play/media/" + urlFilm + "?devicetype=pc&features=hls";
                this.seite3 = getUrlIo.getUri_Utf(MediathekRbb.SENDERNAME, urlFilm, this.seite3, "");
                String urlNormal = "";
                String urlLow = "";
                urlLow = this.getUrlLow("https");
                if (urlLow.isEmpty()) {
                    urlLow = this.getUrlLow("http");
                    if (!urlLow.isEmpty()) {
                        urlLow = "http://" + urlLow;
                    }
                } else {
                    urlLow = "https://" + urlLow;
                }
                if ((urlNormal = this.getUrlNormal("https")).isEmpty()) {
                    urlNormal = this.getUrlNormal("http");
                    if (!urlNormal.isEmpty()) {
                        urlNormal = "http://" + urlNormal;
                    }
                } else {
                    urlNormal = "https://" + urlNormal;
                }
                if (urlLow.contains("?url=")) {
                    urlLow = urlLow.substring(0, urlLow.indexOf("?url="));
                }
                if (urlNormal.contains("?url=")) {
                    urlNormal = urlNormal.substring(0, urlNormal.indexOf("?url="));
                }
                if (urlNormal.isEmpty() && !urlLow.isEmpty()) {
                    urlNormal = urlLow;
                    urlLow = "";
                }
                if (!(subtitle = this.seite3.extract("subtitleUrl\":\"", "\"")).isEmpty() && !subtitle.startsWith("http")) {
                    subtitle = "http://mediathek.rbb-online.de" + subtitle;
                }
                if (datum.isEmpty() || zeit.isEmpty() || thema.isEmpty() || title.isEmpty() || description.isEmpty() || durationInSeconds.isEmpty()) {
                    Log.errorLog(912012036, "empty f\u00fcr: " + urlSeite);
                }
                if (!urlNormal.isEmpty()) {
                    DatenFilm film = new DatenFilm(MediathekRbb.SENDERNAME, thema, urlSeite, title, urlNormal, "", datum, zeit, duration, description);
                    MediathekRbb.this.addFilm(film);
                    if (!urlLow.isEmpty()) {
                        CrawlerTool.addUrlKlein(film, urlLow, "");
                    }
                    if (!subtitle.isEmpty()) {
                        CrawlerTool.addUrlSubtitle(film, subtitle);
                    }
                } else {
                    Log.errorLog(302014569, "keine URL f\u00fcr: " + urlSeite);
                }
            }
            catch (Exception ex) {
                Log.errorLog(541236987, ex);
            }
        }

        private String getUrlNormal(String aProtocol) {
            String urlNormal = this.seite3.extract("\"_quality\":3,\"_server\":\"\",\"_cdn\":\"akamai\",", "\"_stream\":\"" + aProtocol + "://", "\"");
            if (urlNormal.isEmpty()) {
                urlNormal = this.seite3.extract("\"_quality\":3,\"_server\":\"\",\"_cdn\":\"default\"", "\"_stream\":\"" + aProtocol + "://", "\"");
            }
            if (urlNormal.isEmpty()) {
                urlNormal = this.seite3.extract("\"_quality\":3,\"_server\":\"\",\"_cdn\":\"default\",\"_stream\":\"" + aProtocol + "://", "\"");
            }
            return urlNormal;
        }

        private String getUrlLow(String aProtocol) {
            String urlLow = this.seite3.extract("\"_quality\":1,\"_server\":\"\",\"_cdn\":\"akamai\",\"_stream\":\"" + aProtocol + "://", "\"");
            if (urlLow.isEmpty()) {
                urlLow = this.seite3.extract("\"_quality\":1,\"_server\":\"\",\"_cdn\":\"default\",\"_stream\":\"" + aProtocol + "://", "\"");
            }
            return urlLow;
        }
    }
}

