/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;
import mServer.crawler.RunSender;

public class ListeRunSender
extends LinkedList<RunSender> {
    private static final String TRENNER = " | ";
    private static final String SENDER = " Sender ";

    public boolean listeFertig() {
        for (RunSender run : this) {
            if (run.fertig) continue;
            return false;
        }
        return true;
    }

    public RunSender getSender(String sender) {
        for (RunSender run : this) {
            if (!run.sender.equals(sender)) continue;
            return run;
        }
        return null;
    }

    public RunSender senderFertig(String sender) {
        for (RunSender run : this) {
            if (!run.sender.equals(sender)) continue;
            run.fertig = true;
            run.endZeit = new Date();
            return run;
        }
        return null;
    }

    public String getSenderRun() {
        StringBuilder builder = new StringBuilder();
        for (RunSender run : this) {
            if (run.fertig) continue;
            builder.append(run.sender);
            builder.append(' ');
        }
        return builder.toString();
    }

    public int getAnzSenderRun() {
        int ret = 0;
        for (RunSender run : this) {
            if (run.fertig) continue;
            ++ret;
        }
        return ret;
    }

    public int getMax() {
        int ret = 0;
        for (RunSender run : this) {
            ret += run.max;
        }
        return ret;
    }

    public int getProgress() {
        int prog = 0;
        int max = 0;
        for (RunSender run : this) {
            prog += run.progress;
            max += run.max;
        }
        if (prog >= max && max >= 1) {
            prog = max - 1;
        }
        return prog;
    }

    public void inc(String sender, RunSender.Count what) {
        this.inc(sender, what, 1L);
    }

    public void inc(String sender, RunSender.Count what, long i) {
        AtomicLong counter = this.getCounter((String)sender).counter.get((Object)what);
        counter.addAndGet(i);
    }

    public long get(String sender, RunSender.Count what) {
        return this.getCounter((String)sender).counter.get((Object)what).get();
    }

    public String getRate(String sender) {
        String rate = "";
        int dauerSender = this.getSender(sender).getLaufzeitSekunden();
        long groesseByte = this.get(sender, RunSender.Count.SUM_TRAFFIC_BYTE);
        if (groesseByte > 0L && dauerSender > 0) {
            double doub = 1.0 * (double)groesseByte / (double)dauerSender / 1000.0;
            rate = doub < 1.0 ? "<1" : String.format("%.1f", doub);
        }
        return rate;
    }

    public long get(RunSender.Count what) {
        long ret = 0L;
        for (RunSender run : this) {
            ret += run.counter.get((Object)what).get();
        }
        return ret;
    }

    public ArrayList<String> getTextCount(ArrayList<String> ret) {
        this.getTextCount_(ret, new RunSender.Count[]{RunSender.Count.ANZAHL, RunSender.Count.FILME, RunSender.Count.FEHLER, RunSender.Count.FEHLVERSUCHE, RunSender.Count.WARTEZEIT_FEHLVERSUCHE, RunSender.Count.PROXY});
        ret.add("");
        ret.add("");
        this.getTextCount_(ret, new RunSender.Count[]{RunSender.Count.SUM_DATA_BYTE, RunSender.Count.SUM_TRAFFIC_BYTE, RunSender.Count.SUM_TRAFFIC_LOADART_NIX, RunSender.Count.GET_SIZE_SUM, RunSender.Count.GET_SIZE_PROXY});
        ret.add("");
        ret.add("");
        return ret;
    }

    public void getTextSum(ArrayList<String> retArray) {
        String[] titel1 = new String[]{SENDER, " [min] ", " [kB/s] ", "s/Seite", "Threads", "Wait"};
        String zeile = "";
        String[] names = new String[titel1.length];
        for (int i = 0; i < titel1.length; ++i) {
            names[i] = titel1[i];
            zeile = zeile + this.textLaenge(names[i].length(), names[i]) + TRENNER;
        }
        retArray.add(zeile);
        retArray.add("-------------------------------------------------------");
        for (RunSender run : this) {
            int dauerSender = run.getLaufzeitSekunden();
            long groesseByte = this.get(run.sender, RunSender.Count.SUM_TRAFFIC_BYTE);
            long anzahlSeiten = this.get(run.sender, RunSender.Count.ANZAHL);
            String rate = "";
            if (groesseByte > 0L && dauerSender > 0) {
                double doub = 1.0 * (double)groesseByte / (double)dauerSender / 1000.0;
                rate = doub < 1.0 ? "<1" : String.format("%.1f", doub);
            }
            String dauerProSeite = "";
            if (anzahlSeiten > 0L) {
                dauerProSeite = String.format("%.2f", 1.0 * (double)dauerSender / (double)anzahlSeiten);
            }
            zeile = this.textLaenge(titel1[0].length(), run.sender) + TRENNER;
            zeile = zeile + this.textLaenge(titel1[1].length(), run.getLaufzeitMinuten()) + TRENNER;
            zeile = zeile + this.textLaenge(titel1[2].length(), rate) + TRENNER;
            zeile = zeile + this.textLaenge(titel1[3].length(), dauerProSeite) + TRENNER;
            zeile = zeile + this.textLaenge(titel1[4].length(), run.maxThreads + "") + TRENNER;
            zeile = zeile + this.textLaenge(titel1[5].length(), run.waitOnLoad + "") + TRENNER;
            retArray.add(zeile);
        }
        retArray.add("");
        retArray.add("");
    }

    private RunSender getCounter(String sender) {
        for (RunSender run : this) {
            if (!run.sender.equals(sender)) continue;
            return run;
        }
        RunSender ret = new RunSender(sender, 0, 0);
        this.add(ret);
        return ret;
    }

    private ArrayList<String> getTextCount_(ArrayList<String> ret, RunSender.Count[] spalten) {
        String[] names = RunSender.Count.getNames();
        String zeile = " Sender  | ";
        for (int i = 0; i < names.length; ++i) {
            for (RunSender.Count sp : spalten) {
                if (i != sp.ordinal()) continue;
                zeile = zeile + this.textLaenge(names[i].length(), names[i]) + TRENNER;
            }
        }
        ret.add(zeile);
        ret.add("-------------------------------------------------------");
        for (RunSender run : this) {
            zeile = this.textLaenge(SENDER.length(), run.sender) + TRENNER;
            for (int i = 0; i < names.length; ++i) {
                for (RunSender.Count sp : spalten) {
                    if (i != sp.ordinal()) continue;
                    if (i == RunSender.Count.SUM_DATA_BYTE.ordinal() || i == RunSender.Count.SUM_TRAFFIC_BYTE.ordinal() || i == RunSender.Count.SUM_TRAFFIC_LOADART_NIX.ordinal()) {
                        zeile = zeile + this.textLaenge(names[i].length(), String.valueOf(RunSender.getStringZaehler(this.get(run.sender, RunSender.Count.values()[i])))) + TRENNER;
                        continue;
                    }
                    if (i == RunSender.Count.WARTEZEIT_FEHLVERSUCHE.ordinal()) {
                        long l = this.get(run.sender, RunSender.Count.values()[i]);
                        zeile = zeile + this.textLaenge(names[i].length(), String.valueOf(l == 0L ? "0" : (l < 1000L ? "<1" : Long.valueOf(l / 1000L)))) + TRENNER;
                        continue;
                    }
                    zeile = zeile + this.textLaenge(names[i].length(), String.valueOf(this.get(run.sender, RunSender.Count.values()[i]))) + TRENNER;
                }
            }
            ret.add(zeile);
        }
        ret.add("");
        return ret;
    }

    private String textLaenge(int max, String text) {
        if (text.length() > max) {
            text = text.substring(0, max - 1);
        }
        while (text.length() < max) {
            text = text + " ";
        }
        return text;
    }
}

