/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.Const;
import de.mediathekview.mlib.daten.ListeFilme;
import de.mediathekview.mlib.filmesuchen.ListenerFilmeLaden;
import de.mediathekview.mlib.filmesuchen.ListenerFilmeLadenEvent;
import de.mediathekview.mlib.tool.Log;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.event.EventListenerList;
import mServer.crawler.CrawlerConfig;
import mServer.crawler.CrawlerTool;
import mServer.crawler.ListeRunSender;
import mServer.crawler.RunSender;
import mServer.crawler.sender.Mediathek3Sat;
import mServer.crawler.sender.MediathekArd;
import mServer.crawler.sender.MediathekDw;
import mServer.crawler.sender.MediathekHr;
import mServer.crawler.sender.MediathekKika;
import mServer.crawler.sender.MediathekMdr;
import mServer.crawler.sender.MediathekNdr;
import mServer.crawler.sender.MediathekPhoenix;
import mServer.crawler.sender.MediathekRbb;
import mServer.crawler.sender.MediathekReader;
import mServer.crawler.sender.MediathekSr;
import mServer.crawler.sender.MediathekSrf;
import mServer.crawler.sender.MediathekSrfPod;
import mServer.crawler.sender.MediathekSwr;
import mServer.crawler.sender.MediathekWdr;
import mServer.crawler.sender.MediathekZdf;
import mServer.crawler.sender.MediathekZdfTivi;
import mServer.crawler.sender.arte.MediathekArte_de;
import mServer.crawler.sender.arte.MediathekArte_fr;
import mServer.crawler.sender.br.BrCrawler;
import mServer.crawler.sender.orf.OrfCrawler;
import org.apache.commons.lang3.time.FastDateFormat;

public class FilmeSuchen {
    public ListeFilme listeFilmeNeu;
    public ListeFilme listeFilmeAlt;
    private final LinkedList<MediathekReader> mediathekListe = new LinkedList();
    private final EventListenerList listeners = new EventListenerList();
    public static final ListeRunSender listeSenderLaufen = new ListeRunSender();
    private Date startZeit = new Date();
    private Date stopZeit = new Date();
    private boolean allStarted = false;
    private final FastDateFormat sdf = FastDateFormat.getInstance((String)"dd.MM.yyyy HH:mm:ss");

    public FilmeSuchen() {
        this.mediathekListe.add(new MediathekArd(this, 0));
        this.mediathekListe.add(new MediathekZdf(this, 0));
        this.mediathekListe.add(new MediathekZdfTivi(this, 0));
        this.mediathekListe.add(new MediathekArte_de(this, 0));
        this.mediathekListe.add(new MediathekArte_fr(this, 0));
        this.mediathekListe.add(new Mediathek3Sat(this, 1));
        this.mediathekListe.add(new MediathekSwr(this, 0));
        this.mediathekListe.add(new MediathekNdr(this, 1));
        this.mediathekListe.add(new MediathekKika(this, 0));
        this.mediathekListe.add(new MediathekDw(this, 0));
        this.mediathekListe.add(new MediathekMdr(this, 0));
        this.mediathekListe.add(new MediathekWdr(this, 1));
        this.mediathekListe.add(new MediathekHr(this, 0));
        this.mediathekListe.add(new MediathekRbb(this, 1));
        this.mediathekListe.add(new MediathekSr(this, 1));
        this.mediathekListe.add(new BrCrawler(this, 0));
        this.mediathekListe.add(new MediathekSrf(this, 1));
        this.mediathekListe.add(new MediathekSrfPod(this, 0));
        this.mediathekListe.add(new OrfCrawler(this, 1));
        this.mediathekListe.add(new MediathekPhoenix(this, 1));
    }

    public static String[] getNamenSender() {
        return Const.SENDER;
    }

    public void addAdListener(ListenerFilmeLaden listener) {
        this.listeners.add(ListenerFilmeLaden.class, listener);
    }

    public synchronized void filmeBeimSenderLaden(ListeFilme listeFilme) {
        this.initStart(listeFilme);
        this.mrStarten(0);
        if (!Config.getStop()) {
            this.mrWarten();
            this.mrStarten(1);
            this.allStarted = true;
        }
    }

    public void updateSender(String[] nameSender, ListeFilme listeFilme) {
        boolean starten = false;
        this.initStart(listeFilme);
        for (MediathekReader reader : this.mediathekListe) {
            for (String s : nameSender) {
                if (!reader.checkNameSenderFilmliste(s)) continue;
                starten = true;
                new Thread(reader).start();
            }
        }
        this.allStarted = true;
        if (!starten) {
            this.meldenFertig("");
        }
    }

    public synchronized RunSender melden(String sender, int max, int progress, String text) {
        RunSender runSender = listeSenderLaufen.getSender(sender);
        if (runSender != null) {
            runSender.max = max;
            runSender.progress = progress;
        } else {
            runSender = new RunSender(sender, max, progress);
            listeSenderLaufen.add(runSender);
            if (listeSenderLaufen.size() <= 1) {
                this.notifyStart(new ListenerFilmeLadenEvent(sender, text, listeSenderLaufen.getMax(), listeSenderLaufen.getProgress(), this.listeFilmeNeu.size(), false));
            }
        }
        this.notifyProgress(new ListenerFilmeLadenEvent(sender, text, listeSenderLaufen.getMax(), listeSenderLaufen.getProgress(), this.listeFilmeNeu.size(), false));
        this.progressBar();
        return runSender;
    }

    public synchronized void meldenFertig(String sender) {
        RunSender run = listeSenderLaufen.senderFertig(sender);
        if (run != null) {
            long anzahlSeiten = listeSenderLaufen.get(run.sender, RunSender.Count.ANZAHL);
            String rate = listeSenderLaufen.getRate(sender);
            String zeile = "\n";
            zeile = zeile + "-------------------------------------------------------------------------------------\n";
            zeile = zeile + "Fertig " + sender + ": " + new SimpleDateFormat("HH:mm:ss").format(new Date()) + " Uhr, Filme: " + listeSenderLaufen.get(sender, RunSender.Count.FILME) + '\n';
            int sekunden = run.getLaufzeitSekunden();
            zeile = zeile + "     -> Dauer[Min]: " + (sekunden / 60 == 0 ? "<1" : Integer.valueOf(sekunden / 60)) + '\n';
            zeile = zeile + "     ->     [kB/s]: " + rate + '\n';
            zeile = zeile + "     ->     Seiten: " + anzahlSeiten + '\n';
            zeile = zeile + "     ->       Rest: " + listeSenderLaufen.getSenderRun() + '\n';
            zeile = zeile + "-------------------------------------------------------------------------------------\n";
            Log.sysLog(zeile);
        }
        if (!this.allStarted || !listeSenderLaufen.listeFertig()) {
            this.notifyProgress(new ListenerFilmeLadenEvent(sender, "", listeSenderLaufen.getMax(), listeSenderLaufen.getProgress(), this.listeFilmeNeu.size(), false));
        } else {
            Log.progress("");
            if (Config.getStop()) {
                Log.sysLog("                                                                                     ");
                Log.sysLog("                                                                                     ");
                Log.sysLog("*************************************************************************************");
                Log.sysLog("*************************************************************************************");
                Log.sysLog("*************************************************************************************");
                Log.sysLog("     ----- Abbruch -----                                                             ");
                Log.sysLog("*************************************************************************************");
                Log.sysLog("*************************************************************************************");
                Log.sysLog("*************************************************************************************");
                Log.sysLog("                                                                                     ");
                Log.sysLog("                                                                                     ");
            }
            this.mrClear();
            if (CrawlerConfig.updateFilmliste) {
                this.listeFilmeNeu.updateListe(this.listeFilmeAlt, true, false);
            }
            this.listeFilmeNeu.sort();
            this.stopZeit = new Date(System.currentTimeMillis());
            this.listeFilmeNeu.writeMetaData();
            this.endeMeldung().forEach(Log::sysLog);
            this.notifyFertig(new ListenerFilmeLadenEvent(sender, "", listeSenderLaufen.getMax(), listeSenderLaufen.getProgress(), (int)listeSenderLaufen.get(RunSender.Count.FILME), false));
        }
    }

    public ArrayList<String> endeMeldung() {
        ArrayList<String> retArray = new ArrayList<String>();
        retArray.add("");
        retArray.add("");
        retArray.add("=================================================================================");
        retArray.add("==  Sender  =====================================================================");
        retArray.add("");
        listeSenderLaufen.getTextSum(retArray);
        listeSenderLaufen.getTextCount(retArray);
        int sekunden = this.getDauerSekunden();
        retArray.add("");
        retArray.add("=================================================================================");
        retArray.add("=================================================================================");
        retArray.add("");
        retArray.add("       Filme geladen: " + listeSenderLaufen.get(RunSender.Count.FILME));
        retArray.add("      Seiten geladen: " + listeSenderLaufen.get(RunSender.Count.ANZAHL));
        retArray.add("   Summe geladen[MB]: " + RunSender.getStringZaehler(listeSenderLaufen.get(RunSender.Count.SUM_DATA_BYTE)));
        retArray.add("        Traffic [MB]: " + RunSender.getStringZaehler(listeSenderLaufen.get(RunSender.Count.SUM_TRAFFIC_BYTE)));
        double doub = 1.0 * (double)listeSenderLaufen.get(RunSender.Count.SUM_TRAFFIC_BYTE) / (double)(sekunden == 0 ? 1 : sekunden) / 1000.0;
        String rate = doub < 1.0 ? "<1" : String.format("%.1f", doub);
        retArray.add("    ->    Rate[kB/s]: " + rate);
        retArray.add("    ->    Dauer[Min]: " + (sekunden / 60 == 0 ? "<1" : Integer.valueOf(sekunden / 60)));
        retArray.add("           ->  Start: " + this.sdf.format(this.startZeit));
        retArray.add("           ->   Ende: " + this.sdf.format(this.stopZeit));
        retArray.add("");
        retArray.add("=================================================================================");
        retArray.add("=================================================================================");
        return retArray;
    }

    private synchronized void mrStarten(int prio) {
        this.mediathekListe.stream().filter(mr -> mr.getStartPrio() == prio).forEach(mr -> new Thread((Runnable)mr).start());
    }

    private synchronized void mrClear() {
        this.mediathekListe.forEach(MediathekReader::clear);
    }

    private synchronized void mrWarten() {
        try {
            for (int i = 0; i < 240 && !Config.getStop(); ++i) {
                this.wait(1000L);
            }
        }
        catch (Exception ex) {
            Log.errorLog(978754213, ex);
        }
    }

    private int getDauerSekunden() {
        int sekunden;
        try {
            sekunden = Math.round((this.stopZeit.getTime() - this.startZeit.getTime()) / 1000L);
        }
        catch (Exception ex) {
            sekunden = 1;
        }
        if (sekunden <= 0) {
            sekunden = 1;
        }
        return sekunden;
    }

    private void initStart(ListeFilme listeFilme) {
        listeSenderLaufen.clear();
        this.allStarted = false;
        this.listeFilmeAlt = listeFilme;
        Config.setStop(false);
        this.startZeit = new Date(System.currentTimeMillis());
        this.listeFilmeNeu = new ListeFilme();
        Log.sysLog("");
        Log.sysLog("=======================================");
        Log.sysLog("Start Filme laden:");
        if (CrawlerTool.loadMax()) {
            Log.sysLog("Filme laden: max");
        } else if (CrawlerTool.loadLongMax()) {
            Log.sysLog("Filme laden: long");
        } else {
            Log.sysLog("Filme laden: short");
        }
        if (CrawlerConfig.updateFilmliste) {
            Log.sysLog("Filmliste: aktualisieren");
        } else {
            Log.sysLog("Filmliste: neue erstellen");
        }
        Log.sysLog("=======================================");
        Log.sysLog("");
    }

    private void progressBar() {
        int max = listeSenderLaufen.getMax();
        int progress = listeSenderLaufen.getProgress();
        int proz = 0;
        int sekunden = 0;
        try {
            sekunden = Math.round((new Date(System.currentTimeMillis()).getTime() - this.startZeit.getTime()) / 1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (max != 0) {
            int i;
            if (progress != 0) {
                proz = progress * 100 / max;
            }
            if (max > 0 && proz == 100) {
                proz = 99;
            }
            String text = "  [ ";
            int a = proz / 10;
            for (i = 0; i < a; ++i) {
                text = text + "#";
            }
            for (i = 0; i < 10 - a; ++i) {
                text = text + "-";
            }
            text = text + " ]  " + listeSenderLaufen.get(RunSender.Count.ANZAHL) + " Seiten / " + proz + "% von " + max + " Themen / Filme: " + listeSenderLaufen.get(RunSender.Count.FILME) + " / Dauer[Min]: " + (sekunden / 60 == 0 ? "<1" : Integer.valueOf(sekunden / 60)) + " / R-Sender: " + listeSenderLaufen.getAnzSenderRun();
            Log.progress(text);
        }
    }

    private void notifyStart(ListenerFilmeLadenEvent event) {
        for (Object l : this.listeners.getListenerList()) {
            if (!(l instanceof ListenerFilmeLaden)) continue;
            ((ListenerFilmeLaden)l).start(event);
        }
    }

    private void notifyProgress(ListenerFilmeLadenEvent event) {
        for (Object l : this.listeners.getListenerList()) {
            if (!(l instanceof ListenerFilmeLaden)) continue;
            ((ListenerFilmeLaden)l).progress(event);
        }
    }

    private void notifyFertig(ListenerFilmeLadenEvent event) {
        for (Object l : this.listeners.getListenerList()) {
            if (!(l instanceof ListenerFilmeLaden)) continue;
            ((ListenerFilmeLaden)l).fertig(event);
        }
    }
}

