/*
 * Decompiled with CFR 0.152.
 */
package etm.core.monitor.event;

import etm.core.monitor.event.EtmMonitorEvent;
import etm.core.monitor.event.EtmMonitorListener;
import etm.core.monitor.event.EventDispatcher;
import etm.core.util.Log;
import etm.core.util.LogAdapter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DefaultEventDispatcher
implements EventDispatcher {
    private static final LogAdapter log = Log.getLog(class$etm$core$monitor$event$DefaultEventDispatcher == null ? (class$etm$core$monitor$event$DefaultEventDispatcher = DefaultEventDispatcher.class$("etm.core.monitor.event.DefaultEventDispatcher")) : class$etm$core$monitor$event$DefaultEventDispatcher);
    private Map dispatchingRules = new HashMap();
    private Map listeners = new HashMap();
    static /* synthetic */ Class class$etm$core$monitor$event$DefaultEventDispatcher;
    static /* synthetic */ Class class$etm$core$monitor$event$AggregationStateLoadedEvent;
    static /* synthetic */ Class class$etm$core$monitor$event$AggregationStateListener;
    static /* synthetic */ Class class$etm$core$monitor$event$PreMonitorResetEvent;
    static /* synthetic */ Class class$etm$core$monitor$event$AggregationListener;
    static /* synthetic */ Class class$etm$core$monitor$event$MonitorResetEvent;
    static /* synthetic */ Class class$etm$core$monitor$event$RootCreateEvent;
    static /* synthetic */ Class class$etm$core$monitor$event$RootResetEvent;
    static /* synthetic */ Class class$etm$core$monitor$event$PreRootResetEvent;
    static /* synthetic */ Class class$etm$core$monitor$event$CollectionEnabledEvent;
    static /* synthetic */ Class class$etm$core$monitor$event$CollectionStatusListener;
    static /* synthetic */ Class class$etm$core$monitor$event$CollectionDisabledEvent;
    static /* synthetic */ Class class$etm$core$monitor$event$CollectEvent;
    static /* synthetic */ Class class$etm$core$monitor$event$CollectionListener;

    public DefaultEventDispatcher() {
        this.registerDispatchRules();
    }

    public void register(EtmMonitorListener listener) {
        Iterator iterator = this.listeners.keySet().iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            if (!clazz.isAssignableFrom(listener.getClass())) continue;
            Set set = (Set)this.listeners.get(clazz);
            set.add(listener);
        }
    }

    public void deregister(EtmMonitorListener listener) {
        Iterator iterator = this.listeners.keySet().iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            if (!clazz.isAssignableFrom(listener.getClass())) continue;
            Set set = (Set)this.listeners.get(clazz);
            set.remove(listener);
        }
    }

    public void fire(EtmMonitorEvent event) {
        DispatchingRule rule = (DispatchingRule)this.dispatchingRules.get(event.getClass());
        if (rule != null) {
            Set currentListeners = (Set)this.listeners.get(rule.getListener());
            if (currentListeners != null) {
                this.sendEvent(currentListeners.toArray(), rule.getMethod(), event);
            }
        } else {
            log.warn("Unable to process event from type " + event.getClass());
        }
    }

    protected void sendEvent(Object[] aObjects, Method aMethod, EtmMonitorEvent aEvent) {
        for (int i = 0; i < aObjects.length; ++i) {
            Object object = aObjects[i];
            try {
                aMethod.invoke(object, aEvent);
                continue;
            }
            catch (Exception e) {
                log.warn("Unable to send event " + aEvent, e);
            }
        }
    }

    protected void registerDispatchRules() {
        this.dispatchingRules.put(class$etm$core$monitor$event$AggregationStateLoadedEvent == null ? (class$etm$core$monitor$event$AggregationStateLoadedEvent = DefaultEventDispatcher.class$("etm.core.monitor.event.AggregationStateLoadedEvent")) : class$etm$core$monitor$event$AggregationStateLoadedEvent, new DispatchingRule(class$etm$core$monitor$event$AggregationStateListener == null ? (class$etm$core$monitor$event$AggregationStateListener = DefaultEventDispatcher.class$("etm.core.monitor.event.AggregationStateListener")) : class$etm$core$monitor$event$AggregationStateListener, "onStateLoaded"));
        this.dispatchingRules.put(class$etm$core$monitor$event$PreMonitorResetEvent == null ? (class$etm$core$monitor$event$PreMonitorResetEvent = DefaultEventDispatcher.class$("etm.core.monitor.event.PreMonitorResetEvent")) : class$etm$core$monitor$event$PreMonitorResetEvent, new DispatchingRule(class$etm$core$monitor$event$AggregationListener == null ? (class$etm$core$monitor$event$AggregationListener = DefaultEventDispatcher.class$("etm.core.monitor.event.AggregationListener")) : class$etm$core$monitor$event$AggregationListener, "preStateReset"));
        this.dispatchingRules.put(class$etm$core$monitor$event$MonitorResetEvent == null ? (class$etm$core$monitor$event$MonitorResetEvent = DefaultEventDispatcher.class$("etm.core.monitor.event.MonitorResetEvent")) : class$etm$core$monitor$event$MonitorResetEvent, new DispatchingRule(class$etm$core$monitor$event$AggregationListener == null ? (class$etm$core$monitor$event$AggregationListener = DefaultEventDispatcher.class$("etm.core.monitor.event.AggregationListener")) : class$etm$core$monitor$event$AggregationListener, "onStateReset"));
        this.dispatchingRules.put(class$etm$core$monitor$event$RootCreateEvent == null ? (class$etm$core$monitor$event$RootCreateEvent = DefaultEventDispatcher.class$("etm.core.monitor.event.RootCreateEvent")) : class$etm$core$monitor$event$RootCreateEvent, new DispatchingRule(class$etm$core$monitor$event$AggregationListener == null ? (class$etm$core$monitor$event$AggregationListener = DefaultEventDispatcher.class$("etm.core.monitor.event.AggregationListener")) : class$etm$core$monitor$event$AggregationListener, "onRootCreate"));
        this.dispatchingRules.put(class$etm$core$monitor$event$RootResetEvent == null ? (class$etm$core$monitor$event$RootResetEvent = DefaultEventDispatcher.class$("etm.core.monitor.event.RootResetEvent")) : class$etm$core$monitor$event$RootResetEvent, new DispatchingRule(class$etm$core$monitor$event$AggregationListener == null ? (class$etm$core$monitor$event$AggregationListener = DefaultEventDispatcher.class$("etm.core.monitor.event.AggregationListener")) : class$etm$core$monitor$event$AggregationListener, "onRootReset"));
        this.dispatchingRules.put(class$etm$core$monitor$event$PreRootResetEvent == null ? (class$etm$core$monitor$event$PreRootResetEvent = DefaultEventDispatcher.class$("etm.core.monitor.event.PreRootResetEvent")) : class$etm$core$monitor$event$PreRootResetEvent, new DispatchingRule(class$etm$core$monitor$event$AggregationListener == null ? (class$etm$core$monitor$event$AggregationListener = DefaultEventDispatcher.class$("etm.core.monitor.event.AggregationListener")) : class$etm$core$monitor$event$AggregationListener, "preRootReset"));
        this.dispatchingRules.put(class$etm$core$monitor$event$CollectionEnabledEvent == null ? (class$etm$core$monitor$event$CollectionEnabledEvent = DefaultEventDispatcher.class$("etm.core.monitor.event.CollectionEnabledEvent")) : class$etm$core$monitor$event$CollectionEnabledEvent, new DispatchingRule(class$etm$core$monitor$event$CollectionStatusListener == null ? (class$etm$core$monitor$event$CollectionStatusListener = DefaultEventDispatcher.class$("etm.core.monitor.event.CollectionStatusListener")) : class$etm$core$monitor$event$CollectionStatusListener, "onCollectionEnabled"));
        this.dispatchingRules.put(class$etm$core$monitor$event$CollectionDisabledEvent == null ? (class$etm$core$monitor$event$CollectionDisabledEvent = DefaultEventDispatcher.class$("etm.core.monitor.event.CollectionDisabledEvent")) : class$etm$core$monitor$event$CollectionDisabledEvent, new DispatchingRule(class$etm$core$monitor$event$CollectionStatusListener == null ? (class$etm$core$monitor$event$CollectionStatusListener = DefaultEventDispatcher.class$("etm.core.monitor.event.CollectionStatusListener")) : class$etm$core$monitor$event$CollectionStatusListener, "onCollectionDisabled"));
        this.dispatchingRules.put(class$etm$core$monitor$event$CollectEvent == null ? (class$etm$core$monitor$event$CollectEvent = DefaultEventDispatcher.class$("etm.core.monitor.event.CollectEvent")) : class$etm$core$monitor$event$CollectEvent, new DispatchingRule(class$etm$core$monitor$event$CollectionListener == null ? (class$etm$core$monitor$event$CollectionListener = DefaultEventDispatcher.class$("etm.core.monitor.event.CollectionListener")) : class$etm$core$monitor$event$CollectionListener, "onCollect"));
        this.listeners.put(class$etm$core$monitor$event$AggregationStateListener == null ? (class$etm$core$monitor$event$AggregationStateListener = DefaultEventDispatcher.class$("etm.core.monitor.event.AggregationStateListener")) : class$etm$core$monitor$event$AggregationStateListener, new HashSet());
        this.listeners.put(class$etm$core$monitor$event$AggregationListener == null ? (class$etm$core$monitor$event$AggregationListener = DefaultEventDispatcher.class$("etm.core.monitor.event.AggregationListener")) : class$etm$core$monitor$event$AggregationListener, new HashSet());
        this.listeners.put(class$etm$core$monitor$event$CollectionStatusListener == null ? (class$etm$core$monitor$event$CollectionStatusListener = DefaultEventDispatcher.class$("etm.core.monitor.event.CollectionStatusListener")) : class$etm$core$monitor$event$CollectionStatusListener, new HashSet());
        this.listeners.put(class$etm$core$monitor$event$CollectionListener == null ? (class$etm$core$monitor$event$CollectionListener = DefaultEventDispatcher.class$("etm.core.monitor.event.CollectionListener")) : class$etm$core$monitor$event$CollectionListener, new HashSet());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class DispatchingRule {
        private Method method;
        private Class listener;

        public DispatchingRule(Class aListener, String aMethodName) {
            this.listener = aListener;
            Method[] declaredMethods = this.listener.getDeclaredMethods();
            for (int i = 0; i < declaredMethods.length; ++i) {
                Method declaredMethod = declaredMethods[i];
                if (!aMethodName.equals(declaredMethod.getName()) || declaredMethod.getParameterTypes().length != 1) continue;
                this.method = declaredMethod;
                break;
            }
            if (this.method == null) {
                throw new IllegalArgumentException("There is no matching method " + aMethodName + " in " + aListener.getName());
            }
        }

        public Method getMethod() {
            return this.method;
        }

        public Class getListener() {
            return this.listener;
        }
    }
}

