/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.ard;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mServer.crawler.sender.ard.ArdVideoDTO;
import mServer.crawler.sender.newsearch.Qualities;

public class ArdVideoDeserializer
implements JsonDeserializer<ArdVideoDTO> {
    private static final String TEXT_START_HTTP = "http";
    private static final String JSON_OBJECT_MEDIAARRAY = "_mediaArray";
    private static final String JSON_OBJECT_MEDIASTREAMARRAY = "_mediaStreamArray";
    private static final String JSON_ELEMENT_QUALITY = "_quality";
    private static final String JSON_ELEMENT_STREAM = "_stream";
    private static final String JSON_ELEMENT_WIDTH = "_width";
    private static final String JSON_ELEMENT_HEIGHT = "_height";

    private static String addMissingHttpPrefixIfNecessary(String aUrl) {
        if (aUrl.startsWith("//")) {
            return "http:" + aUrl;
        }
        return aUrl;
    }

    public ArdVideoDTO deserialize(JsonElement aJsonElement, Type aType, JsonDeserializationContext aContext) throws JsonParseException {
        JsonObject jsonObject;
        ArdVideoDTO dto = new ArdVideoDTO();
        if (aJsonElement.isJsonObject() && (jsonObject = aJsonElement.getAsJsonObject()).has(JSON_OBJECT_MEDIAARRAY)) {
            HashMap<Qualities, String> urlMap = new HashMap<Qualities, String>();
            JsonArray mediaArray = jsonObject.get(JSON_OBJECT_MEDIAARRAY).getAsJsonArray();
            if (mediaArray.size() > 0) {
                JsonElement mediaArrayItem = mediaArray.get(mediaArray.size() - 1);
                JsonObject item = mediaArrayItem.getAsJsonObject();
                JsonArray streamArray = item.get(JSON_OBJECT_MEDIASTREAMARRAY).getAsJsonArray();
                this.deserializeMediaStreamArray(streamArray, urlMap);
            }
            urlMap.forEach((key, value) -> dto.addVideo((Qualities)((Object)key), (String)value));
        }
        return dto;
    }

    private void deserializeMediaStreamArray(JsonArray streamArray, Map<Qualities, String> urlMap) {
        ArrayList<QualityUrlWidthHeightDTO> qualities = new ArrayList<QualityUrlWidthHeightDTO>();
        streamArray.forEach(streamItem -> qualities.add(this.deserializeUrlInfos(streamItem.getAsJsonObject())));
        this.convertQualities(qualities, urlMap);
    }

    private void convertQualities(List<QualityUrlWidthHeightDTO> qualities, Map<Qualities, String> urlMap) {
        qualities.sort((a, b) -> b.quality.compareTo(a.quality));
        block10: for (int i = 0; i < qualities.size(); ++i) {
            QualityUrlWidthHeightDTO qualityDto = qualities.get(i);
            if (qualityDto.urls.isEmpty()) continue;
            switch (qualityDto.quality) {
                case "1": {
                    this.addUrl(urlMap, Qualities.SMALL, qualityDto.urls.get(0));
                    continue block10;
                }
                case "2": {
                    this.addUrl(urlMap, Qualities.NORMAL, qualityDto.urls.get(qualityDto.urls.size() - 1));
                    continue block10;
                }
                case "3": {
                    if (qualityDto.width >= 1280 && qualityDto.height >= 720) {
                        this.addUrl(urlMap, Qualities.HD, this.getUrl(qualityDto, qualities.get(i + 1)));
                    }
                    if (qualityDto.width != 0 || qualityDto.height != 0) continue block10;
                    String url = this.getUrl(qualityDto, qualities.get(i + 1));
                    if (!url.substring(url.lastIndexOf(47) + 1).startsWith("960")) {
                        this.addUrl(urlMap, Qualities.HD, url);
                        continue block10;
                    }
                    this.addUrl(urlMap, Qualities.NORMAL, url);
                }
            }
        }
    }

    private void addUrl(Map<Qualities, String> urlMap, Qualities quality, String url) {
        if (url != null && !url.isEmpty() && !urlMap.containsKey((Object)quality)) {
            urlMap.put(quality, url);
        }
    }

    private String getUrl(QualityUrlWidthHeightDTO quality, QualityUrlWidthHeightDTO lowerQuality) {
        for (int i = 0; i < quality.urls.size(); ++i) {
            String url = quality.urls.get(i);
            if (lowerQuality.urls.contains(url)) continue;
            return url;
        }
        return "";
    }

    private QualityUrlWidthHeightDTO deserializeUrlInfos(JsonObject stream) {
        QualityUrlWidthHeightDTO dto = new QualityUrlWidthHeightDTO();
        dto.quality = stream.get(JSON_ELEMENT_QUALITY).getAsString();
        JsonElement streamElement = stream.get(JSON_ELEMENT_STREAM);
        if (streamElement.isJsonArray()) {
            JsonArray streamArray = streamElement.getAsJsonArray();
            streamArray.forEach(arrayElement -> dto.urls.add(ArdVideoDeserializer.addMissingHttpPrefixIfNecessary(arrayElement.getAsString())));
        } else {
            dto.urls.add(ArdVideoDeserializer.addMissingHttpPrefixIfNecessary(streamElement.getAsString()));
        }
        if (stream.has(JSON_ELEMENT_WIDTH)) {
            dto.width = stream.get(JSON_ELEMENT_WIDTH).getAsInt();
        }
        if (stream.has(JSON_ELEMENT_HEIGHT)) {
            dto.height = stream.get(JSON_ELEMENT_HEIGHT).getAsInt();
        }
        return dto;
    }

    private class QualityUrlWidthHeightDTO {
        public String quality = "";
        public List<String> urls = new ArrayList<String>();
        public int width;
        public int height;

        private QualityUrlWidthHeightDTO() {
        }
    }
}

