/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.wdr;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import de.mediathekview.mlib.daten.DatenFilm;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import mServer.crawler.CrawlerTool;
import mServer.crawler.sender.newsearch.Qualities;
import mServer.crawler.sender.wdr.HtmlDeserializerBase;
import mServer.crawler.sender.wdr.WdrUrlLoader;
import mServer.crawler.sender.wdr.WdrVideoDto;
import mServer.crawler.sender.wdr.WdrVideoUrlParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class WdrVideoDetailsDeserializer
extends HtmlDeserializerBase {
    private static final String QUERY_URL = "div.videoLink > a";
    private static final String META_PROPERTY_DESCRIPTION = "og:description";
    private static final String META_PROPERTY_TITLE = "og:title";
    private static final String META_PROPERTY_WEBSITE = "og:url";
    private static final String META_PROPERTY_DATE = "dcterms.date";
    private static final String META_PROPERTY_DURATION = "video:duration";
    private static final String JSON_ELEMENT_MEDIAOBJ = "mediaObj";
    private static final String JSON_ATTRIBUTE_URL = "url";
    private static final Logger LOG = LogManager.getLogger(WdrVideoDetailsDeserializer.class);
    private final WdrVideoUrlParser videoUrlParser;
    private final DateTimeFormatter dateFormatDatenFilm = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private final DateTimeFormatter timeFormatDatenFilm = DateTimeFormatter.ofPattern("HH:mm:ss");

    public WdrVideoDetailsDeserializer(WdrUrlLoader aUrlLoader) {
        this.videoUrlParser = new WdrVideoUrlParser(aUrlLoader);
    }

    public DatenFilm deserialize(String theme, Document document) {
        String jsUrl;
        String dateTime;
        String date = "";
        String description = this.getMetaValue(document, "meta[property=%s]", META_PROPERTY_DESCRIPTION);
        String time = "";
        String website = this.getMetaValue(document, "meta[property=%s]", META_PROPERTY_WEBSITE);
        String durationString = this.getMetaValue(document, "meta[property=%s]", META_PROPERTY_DURATION);
        long duration = 0L;
        if (durationString != null && !durationString.isEmpty()) {
            duration = Long.parseLong(durationString);
        }
        if (!(dateTime = this.getMetaValue(document, "meta[name=%s]", META_PROPERTY_DATE)).isEmpty()) {
            try {
                LocalDateTime d = LocalDateTime.parse(dateTime, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                date = d.format(this.dateFormatDatenFilm);
                time = d.format(this.timeFormatDatenFilm);
            }
            catch (DateTimeParseException ex) {
                LOG.error(website, (Throwable)ex);
            }
        }
        if ((jsUrl = this.getVideoJavaScriptUrl(document)).isEmpty()) {
            return null;
        }
        String t = this.getTheme(document, theme);
        if (!t.isEmpty()) {
            theme = t;
        }
        String title = this.getTitle(document, theme);
        WdrVideoDto videoDto = this.videoUrlParser.parse(jsUrl);
        if (!videoDto.getUrl(Qualities.NORMAL).isEmpty()) {
            DatenFilm film = new DatenFilm("WDR", theme, website, title, videoDto.getUrl(Qualities.NORMAL), "", date, time, duration, description);
            if (!videoDto.getSubtitleUrl().isEmpty()) {
                CrawlerTool.addUrlSubtitle(film, videoDto.getSubtitleUrl());
            }
            if (!videoDto.getUrl(Qualities.SMALL).isEmpty()) {
                CrawlerTool.addUrlKlein(film, videoDto.getUrl(Qualities.SMALL), "");
            }
            if (!videoDto.getUrl(Qualities.HD).isEmpty()) {
                CrawlerTool.addUrlHd(film, videoDto.getUrl(Qualities.HD), "");
            }
            return film;
        }
        return null;
    }

    private String getTitle(Document document, String theme) {
        String title = this.getMetaValue(document, "meta[property=%s]", META_PROPERTY_TITLE);
        if (title.startsWith(theme) && !title.equals(theme)) {
            if ((title = title.replaceFirst(theme, "").trim()).trim().startsWith("-")) {
                title = title.replaceFirst("-", "").trim();
            }
            if (title.trim().startsWith(":")) {
                title = title.replaceFirst(":", "").trim();
            }
        }
        return title;
    }

    private String getTheme(Document document, String actualTheme) {
        String theme = "";
        theme = this.getReducedTitleValue(document);
        int firstIndex = theme.indexOf(" - ");
        int lastIndex = theme.lastIndexOf(" - ");
        if (firstIndex > -1) {
            if (theme.substring(0, firstIndex).trim().equals(actualTheme)) {
                return actualTheme;
            }
            if (theme.substring(lastIndex + 3).trim().equals(actualTheme)) {
                return actualTheme;
            }
            theme = theme.substring(lastIndex + 3).trim();
        }
        return theme;
    }

    private String getReducedTitleValue(Document document) {
        String title = "";
        Element titleElement = document.select("title").first();
        if (titleElement != null) {
            title = titleElement.text().replace(" - Sendungen A-Z - Video - Mediathek - WDR", "").replace("- Sendung - Video - Mediathek - WDR", "").replace("- Fernsehen - WDR", "").replace(title, "");
            if (title.startsWith("Video:")) {
                title = title.substring(6).trim();
            }
            if (title.startsWith("- ")) {
                title = title.substring(2).trim();
            }
        }
        return title;
    }

    private String getVideoJavaScriptUrl(Document document) {
        JsonElement mediaObjElement;
        String extension;
        JsonParser jsonParser;
        JsonElement element;
        String urlJs = "";
        Element urlElement = document.select(QUERY_URL).first();
        if (urlElement != null && (element = (jsonParser = new JsonParser()).parse(extension = urlElement.attr("data-extension"))) != null && element.getAsJsonObject().has(JSON_ELEMENT_MEDIAOBJ) && (mediaObjElement = element.getAsJsonObject().get(JSON_ELEMENT_MEDIAOBJ)) != null && mediaObjElement.getAsJsonObject().has(JSON_ATTRIBUTE_URL)) {
            urlJs = mediaObjElement.getAsJsonObject().get(JSON_ATTRIBUTE_URL).getAsString();
        }
        return urlJs;
    }
}

