/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.wdr;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.ListeFilme;
import de.mediathekview.mlib.tool.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import mServer.crawler.sender.wdr.WdrLetterPageDeserializer;
import mServer.crawler.sender.wdr.WdrSendungCallable;
import mServer.crawler.sender.wdr.WdrSendungDto;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class WdrLetterPageCallable
implements Callable<ListeFilme> {
    private final WdrLetterPageDeserializer letterPageDeserializer = new WdrLetterPageDeserializer();
    private final String url;

    public WdrLetterPageCallable(String aUrl) {
        this.url = aUrl;
    }

    @Override
    public ListeFilme call() {
        ListeFilme list = new ListeFilme();
        try {
            if (!Config.getStop()) {
                Document document = Jsoup.connect((String)this.url).get();
                List<WdrSendungDto> sendungen = this.letterPageDeserializer.deserialize(document);
                list.addAll((Collection)this.parse(sendungen));
            }
        }
        catch (IOException ex) {
            Log.errorLog((int)763299002, (Exception)ex);
        }
        return list;
    }

    private ListeFilme parse(List<WdrSendungDto> sendungen) {
        ArrayList filmList = new ArrayList();
        sendungen.forEach(sendung -> {
            ExecutorService executor = Executors.newCachedThreadPool();
            filmList.add(executor.submit(new WdrSendungCallable((WdrSendungDto)sendung)));
        });
        ListeFilme resultList = new ListeFilme();
        filmList.forEach(futureFilms -> {
            try {
                resultList.addAll((Collection)futureFilms.get());
            }
            catch (InterruptedException | ExecutionException ex) {
                Logger.getLogger(WdrLetterPageCallable.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        return resultList;
    }
}

