/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.br;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

public enum Resolution {
    HD(3, "HD"),
    NORMAL(2, "Normal"),
    SMALL(1, "Klein"),
    VERY_SMALL(0, "Sehr klein");

    private final int resolutionSize;
    private final String description;

    private Resolution(int resolutionSize, String description) {
        this.resolutionSize = resolutionSize;
        this.description = description;
    }

    public static List<Resolution> getFromBestToLowest() {
        return Arrays.asList(Resolution.values()).stream().sorted(Comparator.comparing(Resolution::getResolutionSize).reversed()).collect(Collectors.toList());
    }

    public static Resolution getHighestResolution() {
        return HD;
    }

    public static Resolution getLowestResolution() {
        return VERY_SMALL;
    }

    public static Resolution getNextHigherResolution(Resolution startingResolution) {
        return Resolution.getNextResolutionByDirection(startingResolution, CountingDirection.HIGHER);
    }

    public static Resolution getNextLowerResolution(Resolution startingResolution) {
        return Resolution.getNextResolutionByDirection(startingResolution, CountingDirection.LOWER);
    }

    public static Resolution getResolutionFromArdAudioVideoOrdinalsByProfileName(String profileName) {
        if (profileName.endsWith("HD")) {
            return HD;
        }
        if (profileName.endsWith("Premium")) {
            return NORMAL;
        }
        if (profileName.endsWith("Large")) {
            return SMALL;
        }
        if (profileName.endsWith("Standard")) {
            return VERY_SMALL;
        }
        if (profileName.endsWith("Mobile")) {
            return VERY_SMALL;
        }
        if (profileName.endsWith("Mobile_S")) {
            return VERY_SMALL;
        }
        return VERY_SMALL;
    }

    public static Resolution getResolutionFromWidth(int width) {
        if (width >= 1280) {
            return HD;
        }
        if (width >= 969) {
            return NORMAL;
        }
        if (width >= 640) {
            return SMALL;
        }
        return VERY_SMALL;
    }

    static Resolution getNextResolutionByDirection(Resolution startingResolution, CountingDirection direction) {
        try {
            return Resolution.getResoultionByResolutionSize(startingResolution.getResolutionSize() + direction.getDirectionValue());
        }
        catch (NoSuchElementException nsee) {
            return startingResolution;
        }
    }

    static Resolution getResoultionByResolutionSize(int searchedResolutionSize) {
        for (Resolution currentResolution : Resolution.values()) {
            if (searchedResolutionSize != currentResolution.getResolutionSize()) continue;
            return currentResolution;
        }
        throw new NoSuchElementException(String.format("Resolution with ResolutionIndex %d not found", searchedResolutionSize));
    }

    public String getDescription() {
        return this.description;
    }

    public int getResolutionSize() {
        return this.resolutionSize;
    }

    private static enum CountingDirection {
        HIGHER(1),
        LOWER(-1);

        int direction;

        private CountingDirection(int direction) {
            this.direction = direction;
        }

        public int getDirectionValue() {
            return this.direction;
        }
    }
}

