/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.br;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.Optional;
import mServer.crawler.sender.br.BrIdsDTO;

public class BrSendungenIdsDeserializer
implements JsonDeserializer<BrIdsDTO> {
    private static final String JSON_ELEMENT_EDGES = "edges";
    private static final String JSON_ELEMENT_SERIES_INDEX_ALL_SERIES = "seriesIndexAllSeries";
    private static final String JSON_ELEMENT_VIEWER = "viewer";
    private static final String JSON_ELEMENT_DATA = "data";
    private static final String JSON_ELEMENT_ID = "id";
    private static final String JSON_ELEMENT_NODE = "node";

    public BrIdsDTO deserialize(JsonElement aElement, Type aType, JsonDeserializationContext aContext) {
        BrIdsDTO results = new BrIdsDTO();
        JsonObject baseObject = aElement.getAsJsonObject();
        Optional<JsonArray> edges = this.getEdges(baseObject);
        if (edges.isPresent()) {
            for (JsonElement edge : edges.get()) {
                JsonObject node;
                JsonObject ebdgeObj = edge.getAsJsonObject();
                if (!ebdgeObj.has(JSON_ELEMENT_NODE) || !(node = ebdgeObj.getAsJsonObject(JSON_ELEMENT_NODE)).has(JSON_ELEMENT_ID)) continue;
                results.add(node.get(JSON_ELEMENT_ID).getAsString());
            }
        }
        return results;
    }

    private Optional<JsonArray> getEdges(JsonObject aBaseObject) {
        if (!aBaseObject.has(JSON_ELEMENT_DATA)) {
            return Optional.empty();
        }
        JsonObject data = aBaseObject.getAsJsonObject(JSON_ELEMENT_DATA);
        if (!data.has(JSON_ELEMENT_VIEWER)) {
            return Optional.empty();
        }
        JsonObject viewer = data.getAsJsonObject(JSON_ELEMENT_VIEWER);
        if (!viewer.has(JSON_ELEMENT_SERIES_INDEX_ALL_SERIES)) {
            return Optional.empty();
        }
        JsonObject seriesIndexAllSeries = viewer.getAsJsonObject(JSON_ELEMENT_SERIES_INDEX_ALL_SERIES);
        if (!seriesIndexAllSeries.has(JSON_ELEMENT_EDGES)) {
            return Optional.empty();
        }
        return Optional.of(seriesIndexAllSeries.getAsJsonArray(JSON_ELEMENT_EDGES));
    }
}

